/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigs;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationCacheConfig;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationWarning;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EhCacheConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(EhCacheConfigValidator.class);
    private final EhCacheConfigs distroCacheConfigs;
    private final Collection<EhCacheConfigs> historicalCacheConfigs;

    public EhCacheConfigValidator(EhCacheConfigs distroCacheConfigs, Collection<EhCacheConfigs> historicalCacheConfigs) {
        this.distroCacheConfigs = distroCacheConfigs;
        this.historicalCacheConfigs = historicalCacheConfigs;
    }

    Collection<MigrationWarning> validateSiteCacheConfigs(EhCacheConfigs siteCacheConfigs) {
        ArrayList migrationWarnings = Lists.newArrayList();
        for (MigrationCacheConfig namedCache : siteCacheConfigs.getNamedCaches()) {
            migrationWarnings.add(this.checkForMigrationWarnings(namedCache));
        }
        migrationWarnings.add(this.checkSiteDefaultCache(siteCacheConfigs.getDefaultCache()));
        return Collections.unmodifiableCollection(Collections2.filter((Collection)migrationWarnings, (Predicate)Predicates.notNull()));
    }

    MigrationWarning checkForMigrationWarnings(MigrationCacheConfig siteCache) {
        boolean foundAcceptableHistoricalMatch = false;
        for (EhCacheConfigs historicalConfig : this.getMergedHistoricalCacheConfigs()) {
            MigrationCacheConfig baselineConfig = historicalConfig.getCorrespondingCacheConfig(siteCache);
            foundAcceptableHistoricalMatch |= siteCache.equalsExcludingMigratableProperties(baselineConfig);
        }
        if (!foundAcceptableHistoricalMatch) {
            return this.warning(String.format("Existing cache contains customizations that can't be fully migrated: %s", siteCache.name), siteCache, this.distroCacheConfigs.getCorrespondingCacheConfig(siteCache));
        }
        return null;
    }

    private Iterable<EhCacheConfigs> getMergedHistoricalCacheConfigs() {
        return Iterables.concat(Collections.singleton(this.distroCacheConfigs), this.historicalCacheConfigs);
    }

    MigrationWarning checkSiteDefaultCache(MigrationCacheConfig siteCache) {
        MigrationCacheConfig distroDefaultCache = this.distroCacheConfigs.getDefaultCache();
        if (!siteCache.equals(distroDefaultCache)) {
            return this.warning("Existing default cache config differs from that in the distribution. The config for this cache will not be migrated.", siteCache, distroDefaultCache);
        }
        return null;
    }

    private MigrationWarning warning(String message, MigrationCacheConfig siteCacheConfig, MigrationCacheConfig distributionCacheConfig) {
        log.warn(message);
        MigrationWarning migrationWarning = new MigrationWarning(message, siteCacheConfig, distributionCacheConfig);
        return migrationWarning;
    }
}

