/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.validation;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.validator.routines.EmailValidator;

public class IdentityAcceptedEmailValidator {
    public static final String ZERO_WIDTH_SPACE = "\u200b";
    private static final Set<String> BLACKLISTED_DOMAINS = new HashSet<String>();

    public static boolean isValid(String emailAddress) {
        return EmailValidator.getInstance().isValid(emailAddress) && !IdentityAcceptedEmailValidator.isBlacklisted(emailAddress);
    }

    public static String cleanse(String emailAddress) {
        return emailAddress == null ? null : emailAddress.trim().replace(ZERO_WIDTH_SPACE, "");
    }

    private static boolean isBlacklisted(String email) {
        return BLACKLISTED_DOMAINS.stream().anyMatch(domain -> email.toLowerCase(Locale.ENGLISH).trim().endsWith((String)domain));
    }

    static {
        BLACKLISTED_DOMAINS.add("@connect.atlassian.com");
    }
}

