/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EmailFormatChecker
implements Checker<EmailCheckContext> {
    private static final String VIOLATIONS = "violations";

    @Override
    public CheckResult check(EmailCheckContext ctx) {
        List<EmailData> invalidEmails = ctx.emails.stream().filter(d -> !EmailFormatChecker.isEmailValid(d.email)).map(entry -> new EmailData(entry.id, entry.email)).collect(Collectors.toList());
        return new CheckResult(invalidEmails.isEmpty(), this.buildMap(invalidEmails));
    }

    private Map<String, Object> buildMap(List<EmailData> invalidEmails) {
        return Collections.singletonMap(VIOLATIONS, invalidEmails);
    }

    private static boolean isEmailValid(String email) {
        return IdentityAcceptedEmailValidator.isValid((String)email);
    }

    public static List<EmailData> retrieveInvalidEmails(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS, Collections.emptyList());
    }
}

