/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics.events;

import com.atlassian.cmpt.analytics.events.EmailHasher;
import com.atlassian.cmpt.analytics.events.EventType;
import com.atlassian.cmpt.analytics.events.EventValidationResult;
import com.atlassian.cmpt.analytics.events.InvalidEventFormatException;
import com.atlassian.cmpt.crypto.BcryptAnalyticsEmailHasher;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class EventDto {
    public static final String ATTR_MIGRATION = "migration";
    public static final String ATTR_SEN = "SEN";
    public static final String ATTR_SEN_JIRA_CORE = "jiraCoreSen";
    public static final String ATTR_SEN_JIRA_SOFTWARE = "jiraSoftwareSen";
    public static final String ATTR_SEN_JIRA_SERVICE_DESK = "jiraServicedeskSen";
    public static final String ATTR_PLUGIN_VERSION = "version";
    public static final String UNKNOWN_USER_ID_FIELD_VALUE = "unknown";
    private static final BcryptAnalyticsEmailHasher BCRYPT_HASHER = new BcryptAnalyticsEmailHasher();
    static EmailHasher HASHER = arg_0 -> ((BcryptAnalyticsEmailHasher)BCRYPT_HASHER).hash(arg_0);
    public final long timestamp;
    public final EventType eventType;
    public final String userId;
    public final Map<String, Object> attributes = new HashMap<String, Object>();
    @Nullable
    public final String cloudId;

    EventDto(long timestamp, EventType eventType, String userId, Map<String, Object> attributes, String cloudId) {
        this.timestamp = timestamp;
        this.eventType = eventType;
        this.userId = userId;
        this.cloudId = cloudId;
        this.initiateAttributes(attributes);
    }

    EventDto(Builder<?, ?> builder) {
        this.eventType = ((Builder)builder).eventType;
        this.timestamp = ((Builder)builder).timestamp;
        this.userId = ((Builder)builder).userId;
        this.cloudId = ((Builder)builder).cloudId;
        this.initiateAttributes(((Builder)builder).attributes);
    }

    private void initiateAttributes(@Nullable Map<String, Object> attrs) {
        this.attributes.put(ATTR_MIGRATION, Boolean.TRUE);
        if (attrs != null && attrs.size() > 0) {
            this.attributes.putAll(attrs);
        }
    }

    public EventValidationResult validate() {
        return EventValidationResult.OK;
    }

    @Nullable
    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    @Nullable
    public static String hashEmail(@Nullable String email) {
        return HASHER.hashEmail(email);
    }

    public static abstract class Builder<T extends Builder<T, E>, E extends EventDto> {
        private EventType eventType;
        private long timestamp;
        private String userId;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private String cloudId;

        Builder(EventType eventType, long timestamp) {
            this.eventType = Objects.requireNonNull(eventType);
            this.timestamp = timestamp;
        }

        Builder(E event) {
            this.eventType = ((EventDto)event).eventType;
            this.timestamp = ((EventDto)event).timestamp;
            this.userId = ((EventDto)event).userId;
            if (((EventDto)event).attributes != null) {
                this.attributes.putAll(((EventDto)event).attributes);
            }
            this.cloudId = ((EventDto)event).cloudId;
        }

        protected abstract T self();

        public abstract E build();

        public T email(@Nullable String email) {
            String hashedEmail = HASHER.hashEmail(email);
            this.userId = StringUtils.isEmpty((CharSequence)hashedEmail) ? EventDto.UNKNOWN_USER_ID_FIELD_VALUE : hashedEmail;
            return this.self();
        }

        public T sen(@Nullable String sen) {
            if (StringUtils.isNotEmpty((CharSequence)sen)) {
                this.addAttribute(EventDto.ATTR_SEN, sen);
            }
            return this.self();
        }

        public T jiraCoreSen(@Nullable String sen) {
            if (StringUtils.isNotEmpty((CharSequence)sen)) {
                this.addAttribute(EventDto.ATTR_SEN_JIRA_CORE, sen);
            }
            return this.self();
        }

        public T jiraSoftwareSen(@Nullable String sen) {
            if (StringUtils.isNotEmpty((CharSequence)sen)) {
                this.addAttribute(EventDto.ATTR_SEN_JIRA_SOFTWARE, sen);
            }
            return this.self();
        }

        public T jiraServicedeskSen(@Nullable String sen) {
            if (StringUtils.isNotEmpty((CharSequence)sen)) {
                this.addAttribute(EventDto.ATTR_SEN_JIRA_SERVICE_DESK, sen);
            }
            return this.self();
        }

        public T pluginVersion(@Nullable String version) {
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                this.addAttribute(EventDto.ATTR_PLUGIN_VERSION, version);
            }
            return this.self();
        }

        public T addAttribute(String key, @Nullable Object value) {
            Objects.requireNonNull(key);
            if (value != null) {
                this.attributes.put(key, value);
            }
            return this.self();
        }

        public T cloudId(String cloudId) {
            this.cloudId = cloudId;
            return this.self();
        }

        public T withAttributes(@Nullable Map<String, Object> attrs) {
            if (!MapUtils.isEmpty(attrs)) {
                attrs.forEach(this::addAttribute);
            }
            return this.self();
        }

        public E validate(E event) {
            EventValidationResult validationResult = ((EventDto)event).validate();
            if (!validationResult.isValid()) {
                throw new InvalidEventFormatException(validationResult);
            }
            return event;
        }
    }
}

