package com.atlassian.cache.hazelcast;

import com.atlassian.hazelcast.serialization.OsgiSafe;

public final class OsgiSafeUtils
{
    private OsgiSafeUtils()
    {
        // to prevent instantiation
    }

    public static <T> T unwrap(OsgiSafe<T> value)
    {
        return value == null ? null : value.getValue();
    }

    public static <T> OsgiSafe<T> wrap(T value)
    {
        return new OsgiSafe<T>(value);
    }
}
