package com.atlassian.cache.hazelcast;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CachedReference;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.ITopic;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Provides methods for generating the names for various Hazelcast objects used by {@link HazelcastCacheManager}.
 *
 * @since 5.4.0
 */
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public interface HazelcastNameFactory {

    /**
     * @return The name of the {@link IMap} to be used for the given {@link Cache} name.
     */
    String getCacheIMapName(String cacheName);

    /**
     * @return The name of the {@link IMap} to be used for the given {@link CachedReference} name.
     */
    String getCachedReferenceIMapName(String cacheName);

    /**
     * @return the name of the invalidation {@link ITopic} to be used for the given {@link Cache} name
     */
    String getCacheInvalidationTopicName(String cacheName);

    /**
     * @return The name of the invalidation {@link ITopic} to be used for the given {@link CachedReference} name.
     */
    String getCachedReferenceInvalidationTopicName(String cacheName);

    /**
     * @return The name of the version counter {@link IAtomicLong} to be used for the given {@link Cache} name
     */
    String getCacheVersionCounterName(String cacheName);
}
