package com.atlassian.cache.hazelcast;

import com.hazelcast.map.EntryProcessor;

import java.util.Map;

class GetOrInitVersionEntryProcessor<K> implements EntryProcessor<K, Long, Long>
{
    private static GetOrInitVersionEntryProcessor<Object> INSTANCE = new GetOrInitVersionEntryProcessor<Object>();

    protected static <T> GetOrInitVersionEntryProcessor<T> getInstance()
    {
        //noinspection unchecked
        return (GetOrInitVersionEntryProcessor<T>) INSTANCE;
    }

    private GetOrInitVersionEntryProcessor()
    {
    }

    @Override
    public Long process(Map.Entry<K, Long> entry)
    {
        Long value = entry.getValue();
        if (value == null)
        {
            value = 1L;
            entry.setValue(value);
        }
        return value;
    }
}
