/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.hallelujah;

import com.atlassian.buildeng.hallelujah.ClientTestCaseProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import org.apache.log4j.Logger;

public class DefaultClientTestCaseProvider
implements ClientTestCaseProvider {
    private static final long SERVER_DISAPPEARED_MILLIS = 60000L;
    private static final long DEFAULT_SERVER_RETRY_MILLIS = 5000L;
    private static final int HTTP_OK = 200;
    private static final Logger log = Logger.getLogger(DefaultClientTestCaseProvider.class);
    private long lastSendMillis;
    private long lastReceiveMillis;
    private boolean initialised;
    private final String serverBaseUri;
    private WebResource webResource;
    private boolean lastServerConnectionWasSucessful = false;
    private long serverRetryMillis = 5000L;

    public DefaultClientTestCaseProvider(String serverBaseUri) {
        this.serverBaseUri = serverBaseUri;
        this.initialised = false;
    }

    private void ensureInitialised() {
        if (!this.initialised) {
            this.lastSendMillis = System.currentTimeMillis();
            this.lastReceiveMillis = System.currentTimeMillis();
            Client client = Client.create();
            this.webResource = client.resource(this.serverBaseUri);
            this.initialised = true;
        }
    }

    @Override
    public String getNextTestName() {
        this.ensureInitialised();
        String nextTestName = null;
        boolean waitingForTest = true;
        while (waitingForTest) {
            long nowMillis = System.currentTimeMillis();
            if (Math.abs(nowMillis - this.lastReceiveMillis) > 60000L) {
                log.info((Object)"Haven't received a message from the server in a long time...");
                waitingForTest = false;
                continue;
            }
            if (Math.abs(nowMillis - this.lastSendMillis) > this.serverRetryMillis) {
                log.info((Object)"Trying to receive a message from the server");
                this.lastServerConnectionWasSucessful = false;
                ClientResponse response = null;
                try {
                    response = (ClientResponse)this.webResource.path("/test/next").accept(new String[]{"text/plain"}).get(ClientResponse.class);
                }
                catch (ClientHandlerException e) {
                    log.info((Object)("Error connecting to server: " + (Object)((Object)e)));
                }
                if (response != null) {
                    int responseStatus = response.getStatus();
                    if (responseStatus == 200) {
                        String textEntity;
                        this.lastServerConnectionWasSucessful = true;
                        nextTestName = textEntity = (String)response.getEntity(String.class);
                        log.info((Object)("Next test name: " + nextTestName));
                        this.lastReceiveMillis = System.currentTimeMillis();
                        waitingForTest = false;
                    } else {
                        log.info((Object)("Client test case provider got a server response but had status: " + responseStatus));
                    }
                }
                this.lastSendMillis = System.currentTimeMillis();
                this.updateServerRetryMillis();
                continue;
            }
            log.info((Object)("Client test case provider sleeping for " + this.serverRetryMillis + " milliseconds"));
            this.sleep(this.serverRetryMillis);
        }
        return nextTestName;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long updateServerRetryMillis() {
        this.serverRetryMillis = this.lastServerConnectionWasSucessful ? (this.serverRetryMillis /= 2L) : 5000L;
        return this.serverRetryMillis;
    }
}

