package com.atlassian.buildeng.hallelujah;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

public class DefaultClientTestCaseResultCollector implements ClientTestCaseResultCollector
{
    private final String serverBaseUri;

    private Map<String,ClientTestCaseResult> testCaseResults;
    private WebResource webResource;
    private static final Logger log = Logger.getLogger(DefaultClientTestCaseResultCollector.class);
    private static final int HTTP_OK = 200;

    public DefaultClientTestCaseResultCollector(final String serverBaseUri)
    {
        this.serverBaseUri = serverBaseUri;
        this.testCaseResults = new HashMap<String, ClientTestCaseResult>();

        Client client = Client.create();
        webResource = client.resource(serverBaseUri);
    }

    @Override
    public void addResult(ClientTestCaseResult clientTestCaseResult)
    {
        testCaseResults.put(clientTestCaseResult.getName(), clientTestCaseResult);

        String testCaseResultMessage = clientTestCaseResult.toString();

        ClientResponse response = null;
        try
        {
            response = webResource.path("/test/result").type("text/plain").post(ClientResponse.class, testCaseResultMessage);
        }
        catch (ClientHandlerException e)
        {
            log.info("Error connecting to server: " + e);
            /* swallow */
        }

        if (response != null)
        {
            int responseStatus = response.getStatus();
            if (responseStatus == HTTP_OK)
            {
                String textEntity = response.getEntity(String.class);
            }
            else
            {
                log.info("Client test case result collector got a server response but had status: " + responseStatus);
            }
        }
        else
        {

        }
    }

    @Override
    public boolean hasResultsForTest(String testCaseName)
    {
        return testCaseResults.containsKey(testCaseName);
    }
}
