/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.hallelujah;

import com.atlassian.buildeng.hallelujah.ClientTestCaseResult;
import com.atlassian.buildeng.hallelujah.ClientTestCaseResultCollector;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultClientTestCaseResultCollector
implements ClientTestCaseResultCollector {
    private final String serverBaseUri;
    private Map<String, ClientTestCaseResult> testCaseResults;
    private WebResource webResource;
    private static final Logger log = Logger.getLogger(DefaultClientTestCaseResultCollector.class);
    private static final int HTTP_OK = 200;

    public DefaultClientTestCaseResultCollector(String serverBaseUri) {
        this.serverBaseUri = serverBaseUri;
        this.testCaseResults = new HashMap<String, ClientTestCaseResult>();
        Client client = Client.create();
        this.webResource = client.resource(serverBaseUri);
    }

    @Override
    public void addResult(ClientTestCaseResult clientTestCaseResult) {
        this.testCaseResults.put(clientTestCaseResult.getName(), clientTestCaseResult);
        String testCaseResultMessage = clientTestCaseResult.toString();
        ClientResponse response = null;
        try {
            response = (ClientResponse)this.webResource.path("/test/result").type("text/plain").post(ClientResponse.class, (Object)testCaseResultMessage);
        }
        catch (ClientHandlerException e) {
            log.info((Object)("Error connecting to server: " + (Object)((Object)e)));
        }
        if (response != null) {
            int responseStatus = response.getStatus();
            if (responseStatus == 200) {
                String textEntity = (String)response.getEntity(String.class);
            } else {
                log.info((Object)("Client test case result collector got a server response but had status: " + responseStatus));
            }
        }
    }

    @Override
    public boolean hasResultsForTest(String testCaseName) {
        return this.testCaseResults.containsKey(testCaseName);
    }
}

