/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.hallelujah.jms;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;

public class JMSConfiguration {
    private static final Logger log = Logger.getLogger(JMSConfiguration.class);
    private static final String CONFIG_DIR = "/tmp";
    private static final String CONFIG_FILE = "jmsconfig";
    private static final int ID_LENGTH = 12;
    private AtomicBoolean preFetching = new AtomicBoolean(false);
    private final String brokerUrl;
    private final String testNameQueue;
    private final String testResultQueue;
    private final String id;
    private final String controlTopic;

    private JMSConfiguration(String brokerUrl, String queuePrefix, String id) {
        this.brokerUrl = brokerUrl;
        this.testNameQueue = queuePrefix + "-test-name";
        this.testResultQueue = queuePrefix + "-test-result";
        this.controlTopic = queuePrefix + "-control";
        this.id = id;
    }

    private JMSConfiguration(String brokerUrl, String testNameQueue, String testResultQueue, String id) {
        this.brokerUrl = brokerUrl;
        this.testNameQueue = testNameQueue;
        this.testResultQueue = testResultQueue;
        this.controlTopic = testNameQueue + "-control";
        this.id = id;
    }

    private JMSConfiguration(File jmsConfig) {
        List config;
        try {
            config = FileUtils.readLines((File)jmsConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.brokerUrl = (String)config.get(0);
        this.testNameQueue = (String)config.get(1);
        this.testResultQueue = (String)config.get(2);
        this.id = config.size() > 3 ? (String)config.get(3) : RandomStringUtils.randomAlphanumeric((int)12);
        this.controlTopic = this.testNameQueue + "-control";
    }

    public static JMSConfiguration fromFile(File jmsConfig) {
        return new JMSConfiguration(jmsConfig);
    }

    public static JMSConfiguration fromSystemPropertiesRespectingDefaultFile() {
        JMSConfiguration jmsConfiguration;
        JMSConfiguration jmsConfigurationFromFile = JMSConfiguration.fromDefaultFile();
        if (jmsConfigurationFromFile == null) {
            jmsConfiguration = JMSConfiguration.fromSystemProperties();
        } else {
            String brokerUrl = System.getProperty("hallelujah.broker.url", jmsConfigurationFromFile.getBrokerUrl());
            String queueId = System.getProperty("hallelujah", jmsConfigurationFromFile.getTestNameQueue().replace("-name-queue", ""));
            String clientId = System.getProperty("hallelujah.client.id", jmsConfigurationFromFile.getId());
            jmsConfiguration = JMSConfiguration.fromParams(brokerUrl, queueId, clientId);
        }
        return jmsConfiguration;
    }

    public static JMSConfiguration fromDefaultFile() {
        File defaultConfigFile = new File(CONFIG_DIR, CONFIG_FILE);
        if (defaultConfigFile.exists()) {
            return new JMSConfiguration(defaultConfigFile);
        }
        return null;
    }

    public static String getBrokerUrlFromDefaultFile() {
        return JMSConfiguration.fromDefaultFile().getBrokerUrl();
    }

    public static JMSConfiguration fromParams(String brokerUrl, String testNameQueue, String testResultQueue, String id) {
        return new JMSConfiguration(brokerUrl, testNameQueue, testResultQueue, id);
    }

    public static JMSConfiguration fromParams(String brokerUrl, String queueId, String clientId) {
        return new JMSConfiguration(brokerUrl, queueId, clientId);
    }

    public static JMSConfiguration fromSystemProperties() {
        String brokerUrl = System.getProperty("hallelujah.broker.url", "tcp://localhost:61616");
        String queueId = System.getProperty("hallelujah.queue.id", "hallelujah");
        String clientId = System.getProperty("hallelujah.client.id", "client-" + RandomStringUtils.randomAlphanumeric((int)12));
        return JMSConfiguration.fromParams(brokerUrl, queueId, clientId);
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public String getTestNameQueue() {
        return this.testNameQueue;
    }

    public String getTestResultQueue() {
        return this.testResultQueue;
    }

    public String getControlTopic() {
        return this.controlTopic;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "JMSConfiguration{preFetching=" + this.preFetching + ", brokerUrl='" + this.brokerUrl + '\'' + ", testNameQueue='" + this.testNameQueue + '\'' + ", testResultQueue='" + this.testResultQueue + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

