package com.atlassian.buildeng.hallelujah.api.server;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;
import com.atlassian.buildeng.hallelujah.api.server.ServerListener;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseProvider;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseResultCollector;

public abstract class AbstractServerListener implements ServerListener
{
    @Override
    public void onFinish(final ServerTestCaseProvider clientTestCaseProvider, final ServerTestCaseResultCollector clientTestCaseResultCollector)
    {
    }

    @Override
    public void onStart(final ServerTestCaseProvider clientTestCaseProvider, final ServerTestCaseResultCollector clientTestCaseResultCollector)
    {
    }

    @Override
    public void onServerTimeout(final ServerTestCaseProvider serverTestCaseProvider, final ServerTestCaseResultCollector serverTestCaseResultCollector)
    {
    }

    @Override
    public void onNewTestAdded(final ServerTestCaseResultCollector serverTestCaseResultCollector, final ServerTestCaseProvider serverTestCaseProvider, final TestCaseName testCaseName)
    {
    }

    @Override
    public boolean onResultReceived(final ServerTestCaseResultCollector serverTestCaseResultCollector, final ServerTestCaseProvider serverTestCaseProvider, final TestCaseResult testCaseResult)
    {
        return true;
    }
}
