package com.atlassian.buildeng.hallelujah.api.client;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;

/**
 * Listener that can be registered with {@code com.atlassian.buildeng.hallelujah.HallelujahClient} to halt test running
 * if required. Consider inherting from AbstractClientListener if you
 * are only interested in a few methods.
 */
public interface ClientListener
{

    boolean onTestStart(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseName testCaseName);

    /**
     * Run when a test passes after being run. Will stop execution of the client if it
     * returns false.
     * 
     * @param clientTestCaseRunner Test runner in use. See {@link ClientTestCaseRunner} 
     * @param clientTestCaseProvider Test provider in use. See {@link ClientTestCaseProvider}
     * @param clientTestCaseResultCollector Test collector in use. See {@link ClientTestCaseResultCollector}.
     * @param result Passing test result. See {@link com.atlassian.buildeng.hallelujah.api.model.TestCaseResult}
     * @return whether to stop the client; false will stop the client, true will let it proceed
     */
    boolean onPass(final ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result);

    /**
     * Run when a test fails after being run. Will stop execution of the client if it
     * returns false.
     *
     * @param clientTestCaseRunner Test runner in use. See {@link ClientTestCaseRunner}
     * @param clientTestCaseProvider Test provider in use. See {@link ClientTestCaseProvider}
     * @param clientTestCaseResultCollector Test collector in use. See {@link ClientTestCaseResultCollector}.
     * @param result Failing test result. See {@link TestCaseResult}
     * @return whether to stop the client; false will stop the client, true will let it proceed
     */
    boolean onFailure(final ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result);

    /**
     * Run when a test errors after being run. Will stop execution of the client if it
     * returns false.
     *
     * @param clientTestCaseRunner Test runner in use. See {@link ClientTestCaseRunner}
     * @param clientTestCaseProvider Test provider in use. See {@link ClientTestCaseProvider}
     * @param clientTestCaseResultCollector Test collector in use. See {@link ClientTestCaseResultCollector}.
     * @param result Erroring test result. See {@link TestCaseResult}
     * @return whether to stop the client; false will stop the client, true will let it proceed
     */
    boolean onError(final ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result);

    /**
     * Run after the client finishes.
     *
     * @param clientTestCaseRunner Test runner in use. See {@link ClientTestCaseRunner}
     * @param clientTestCaseProvider Test provider in use. See {@link ClientTestCaseProvider}
     * @param clientTestCaseResultCollector Test collector in use. See {@link ClientTestCaseResultCollector}.
     */
    void onFinish(final ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector);

    /**
     * Run after before client starts running tests.
     *
     * @param clientTestCaseRunner Test runner in use. See {@link ClientTestCaseRunner}
     * @param clientTestCaseProvider Test provider in use. See {@link ClientTestCaseProvider}
     * @param clientTestCaseResultCollector Test collector in use. See {@link ClientTestCaseResultCollector}.
     */
    void onStart(final ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector);

}
