package com.atlassian.buildeng.hallelujah.api.client;

import com.atlassian.buildeng.hallelujah.api.client.ClientListener;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseProvider;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseResultCollector;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseRunner;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;

/**
 * Convenience class providing implementations of {@link ClientListener} that will not interrupt a running HallelujahClient
 */
public abstract class AbstractClientListener implements ClientListener
{
    @Override
    public boolean onPass(final ClientTestCaseRunner clientTestCaseRunner, final ClientTestCaseProvider clientTestCaseProvider, final ClientTestCaseResultCollector clientTestCaseResultCollector, final TestCaseResult result)
    {
        return true;
    }

    @Override
    public boolean onFailure(final ClientTestCaseRunner clientTestCaseRunner, final ClientTestCaseProvider clientTestCaseProvider, final ClientTestCaseResultCollector clientTestCaseResultCollector, final TestCaseResult result)
    {
        return true;
    }

    @Override
    public boolean onError(final ClientTestCaseRunner clientTestCaseRunner, final ClientTestCaseProvider clientTestCaseProvider, final ClientTestCaseResultCollector clientTestCaseResultCollector, final TestCaseResult testCaseResult)
    {
        return true;
    }

    @Override
    public void onFinish(final ClientTestCaseRunner clientTestCaseRunner, final ClientTestCaseProvider clientTestCaseProvider, final ClientTestCaseResultCollector clientTestCaseResultCollector)
    {
    }

    @Override
    public void onStart(final ClientTestCaseRunner clientTestCaseRunner, final ClientTestCaseProvider clientTestCaseProvider, final ClientTestCaseResultCollector clientTestCaseResultCollector)
    {
    }

    @Override
    public boolean onTestStart(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseName testCaseName)
    {
        return true;
    }
}
