/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.ProcessRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final int BUFFER = 2048;
    private static final int EXEC_MASK = 73;

    private Utils() {
    }

    public static void make755(File file) throws IOException {
        ProcessRunner.runProcess(new ProcessBuilder("chmod", "755", file.getCanonicalPath()));
    }

    @Nonnull
    public static Iterable<File> findFiles(@Nonnull File in, String ... names) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"in");
        Preconditions.checkNotNull((Object)names, (Object)"names");
        return ImmutableList.copyOf((Collection)FileUtils.listFiles((File)in, (IOFileFilter)new NameFileFilter(names), (IOFileFilter)TrueFileFilter.INSTANCE));
    }

    @Nonnull
    public static Iterable<File> findFiles(@Nonnull File in, @Nonnull Iterable<String> names) throws IOException {
        return Utils.findFiles(in, (String[])Iterables.toArray(names, String.class));
    }

    public static File findFile(File in, final String file, final boolean exactMatch) throws IOException {
        File[] dirs;
        File[] files = in.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isDir = new File(dir, name).isDirectory();
                if (exactMatch) {
                    return !isDir && name.equals(file);
                }
                return !isDir && name.contains(file);
            }
        });
        if (files.length > 0) {
            return files[0];
        }
        for (File dir : dirs = in.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            File f = Utils.findFile(dir, file, exactMatch);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public static boolean resourceExists(String path) {
        return Utils.class.getResource(path) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractZip(File destDir, String internalPath) throws IOException {
        InputStream internalStream = null;
        File targetDir = new File(destDir, internalPath.substring(internalPath.lastIndexOf(47), internalPath.length() - ".zip".length()));
        if (targetDir.exists()) {
            return targetDir;
        }
        try {
            log.info("unzipping {}", (Object)internalPath);
            targetDir.mkdirs();
            internalStream = Utils.class.getResourceAsStream(internalPath);
            if (internalStream == null) {
                throw new IOException("Zip file not found: " + internalPath);
            }
            File tempFile = File.createTempFile("firefox", "zip");
            try (BufferedInputStream bis = new BufferedInputStream(internalStream);){
                Files.copy(bis, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            var6_6 = null;
            try (ZipFile zip = new ZipFile(tempFile);){
                Enumeration iterator = zip.getEntries();
                while (iterator.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)iterator.nextElement();
                    if (entry.getName().endsWith("/")) {
                        new File(targetDir, entry.getName()).mkdirs();
                        continue;
                    }
                    File file = new File(targetDir, entry.getName());
                    try (FileOutputStream fos = new FileOutputStream(file);
                         InputStream is = zip.getInputStream(entry);
                         BufferedInputStream bis = new BufferedInputStream(is);){
                        IOUtils.copy((InputStream)bis, (OutputStream)fos);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if ((entry.getUnixMode() & 0x49) <= 0) continue;
                    file.setExecutable(true);
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(internalStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)internalStream);
        return targetDir;
    }
}

