(function(window) {
    /* global require: true, define: true */

    'use strict';

    // Almond claims to be AMD compatible, but isn't.
    delete define.amd;

    var oldRequire = require;
    var logged = false;
    require = function(modules, cb) {
        if (typeof modules === 'string' && typeof cb === 'function') {
            if (!logged) {
                logged = true;
                console.log('WARN: require(string, function) has been deprecated in 2.11 and will throw an error' +
                    ' in 4.0. Use an array of dependencies - require(Array<string> function). (requiring '  + modules + ')');
            }
            modules = [modules];
        }

        //only allow the use of a callback as the second param, don't expose any other almond internal params.
        //https://github.com/requirejs/almond/blob/0.3.0/almond.js#L337
        if (cb && typeof cb !== 'function') {
            cb = undefined;
        }
        return oldRequire.call(window, modules, cb);
    };

    window.requireLite = require; // Used for testing
    window.defineLite = define; // Used for testing
})(window || this);
