/*
 * Polyfill for Promise.prototype.finally from the TC39 proposal: https://github.com/tc39/proposal-promise-finally
 *
 * This code is based on the MIT licensed code at https://github.com/tc39/proposal-promise-finally/blob/master/polyfill.js
 *
 * It has been run through Babel manually since code in 'lib' does not get transpiled, some unreachable code has been
 * removed, it was simplified so that it'd work properly with the IE11 Promise polyfill, and it was wrapped in an IIFE.
 */
(function () {
    'use strict';

    if (typeof Promise !== 'function') {
        throw new TypeError('A global Promise is required');
    }

    if (typeof Promise.prototype.finally !== 'function') {
        var shim = {
            finally: function _finally(onFinally) {
                var handler = typeof onFinally === 'function' ? onFinally : function () {};
                return this.then( // changed from Promise.prototype.then.call to work with NPO polyfill
                    function (value) {
                        return new Promise(function (resolve) {
                            return resolve(handler());
                        }).then(function () {
                            return value;
                        });
                    }, function (e) {
                        return new Promise(function (resolve) {
                            return resolve(handler());
                        }).then(function () {
                            throw e;
                        });
                    }
                );
            },
        };
        Promise.prototype.finally = shim.finally; // eslint-disable-line no-extend-native
    }
})();
