define('bitbucket/internal/page/global-repository-list/global-repository-list', ['module', 'exports', 'jquery', 'bitbucket/util/navbuilder', 'bitbucket/internal/feature/repository/repository-table/repository-table'], function (module, exports, _jquery, _navbuilder, _repositoryTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _repositoryTable2 = babelHelpers.interopRequireDefault(_repositoryTable);

    function GlobalRepositoryTable(repositoryTableSelector, options) {
        options = _jquery2.default.extend({
            showProject: true,
            bufferPixels: (0, _jquery2.default)('#footer').height()
        }, options);
        _repositoryTable2.default.call(this, repositoryTableSelector, options);
    }

    _jquery2.default.extend(GlobalRepositoryTable.prototype, _repositoryTable2.default.prototype);

    GlobalRepositoryTable.prototype.buildUrl = function (start, limit) {
        return _navbuilder2.default.allRepos().visibility('public').withParams({
            avatarSize: bitbucket.internal.widget.avatarSizeInPx({
                size: 'small'
            }),
            start: start,
            limit: limit
        }).build();
    };

    function onReady(repositoryTableSelector) {
        if ((0, _jquery2.default)(repositoryTableSelector).length) {
            new GlobalRepositoryTable(repositoryTableSelector).init();
        }
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});