define('bitbucket/internal/feature/repository/repository-table/repository-table', ['module', 'exports', 'aui', 'jquery', 'lodash', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/internal/model/page-state', 'bitbucket/internal/widget/paged-table/paged-table'], function (module, exports, _aui, _jquery, _lodash, _events, _navbuilder, _pageState, _pagedTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _aui2 = babelHelpers.interopRequireDefault(_aui);

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _lodash2 = babelHelpers.interopRequireDefault(_lodash);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _pageState2 = babelHelpers.interopRequireDefault(_pageState);

    var _pagedTable2 = babelHelpers.interopRequireDefault(_pagedTable);

    function RepositoryTable(repositoryTableSelector, options) {
        var defaults = {
            target: repositoryTableSelector,
            ajaxDataType: 'json',
            tableMessageClass: 'repository-table-message',
            allFetchedMessageHtml: '<p class="no-more-results">' + _aui2.default.I18n.getText('bitbucket.web.repository.allfetched') + '</p>',
            noneFoundMessageHtml: '<h3 class="no-results entity-empty">' + _aui2.default.I18n.getText('bitbucket.web.repository.nonefetched') + '</h3>',
            statusCode: {
                401: function _() {
                    //If the project is not accessible display no repos
                    return _jquery2.default.Deferred().resolve({
                        start: 0,
                        size: 0,
                        values: [],
                        isLastPage: true
                    }).promise();
                }
            },
            paginationContext: 'repository-table'
        };
        options = _lodash2.default.assign({}, defaults, options);
        _pagedTable2.default.call(this, options);

        if (options.projectKey) {
            // This is a dirty hack for the profile page
            this._project = { key: options.projectKey, public: false };
        } else {
            var currentProject = _pageState2.default.getProject();
            this._project = currentProject && currentProject.toJSON();
        }
        this._options = options;

        this.bindUIEvents();
    }

    _lodash2.default.assign(RepositoryTable.prototype, _pagedTable2.default.prototype);

    RepositoryTable.prototype.bindUIEvents = function () {
        // N.B. the create repo link is in the sidebar
        (0, _jquery2.default)('.create-repository-link').on('click', 'a', _events2.default.trigger.bind(null, 'bitbucket.internal.ui.repository-list.create.clicked'));
        (0, _jquery2.default)(this.options.target).on('click', 'a', function () {
            var $el = (0, _jquery2.default)(this);
            var projectId = _pageState2.default.getProject() ? _pageState2.default.getProject().id : // see if the repo table includes the project.
            $el.closest('td').find('.project-name a').attr('data-project-id');
            _events2.default.trigger('bitbucket.internal.ui.repository-list.item.clicked', null, {
                repositoryId: $el.attr('data-repository-id'),
                projectId: projectId
            });
        });
    };

    RepositoryTable.prototype.buildUrl = function (start, limit) {
        return _navbuilder2.default.project(this._project.key).allRepos().withParams({
            start: start,
            limit: limit
        }).build();
    };

    RepositoryTable.prototype.handleNewRows = function (data, attachmentMethod) {
        // This is a dirty hack for the profile page
        var currentProject = this._project;
        var options = this._options;
        var rows = _lodash2.default.map(data.values, function (repo) {
            if (!repo.project) {
                if (currentProject) {
                    repo.project = currentProject;
                } else {
                    // If this occurs it is a programming error and we want to fail loudly
                    throw new Error('No project was provided for repo id=' + repo.id + ' slug=' + repo.slug + ' but we are in a global context');
                }
            }
            return bitbucket.internal.feature.repository.repositoryRow({
                repository: repo,
                showProject: options.showProject,
                showPublicStatus: options.showPublicStatus
            });
        });
        this.$table.show().children('tbody')[attachmentMethod !== 'html' ? attachmentMethod : 'append'](rows.join(''));
    };

    RepositoryTable.prototype.handleErrors = function (errors) {};

    exports.default = RepositoryTable;
    module.exports = exports['default'];
});