define('bitbucket/internal/feature/repository/branch-table-pull-requests/branch-table-pull-requests', ['module', 'exports', 'jquery', 'bitbucket/internal/feature/pull-request/list-dialog/pull-request-list-dialog', 'bitbucket/internal/util/dom-event'], function (module, exports, _jquery, _pullRequestListDialog, _domEvent) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _pullRequestListDialog2 = babelHelpers.interopRequireDefault(_pullRequestListDialog);

    var _domEvent2 = babelHelpers.interopRequireDefault(_domEvent);

    function onReady() {
        (0, _jquery2.default)('.branch-list-panel').on('click', '.pull-request-list-trigger', function (e) {
            if (e.target.tagName === 'A' && !_domEvent2.default.openInSameTab(e)) {
                // The user is attempting to open the PR in a separate tab/window.
                // Let the browser handle the click event natively
                return;
            }
            e.preventDefault();
            var branchId = (0, _jquery2.default)(this).closest('[data-branch-id]').attr('data-branch-id');
            _pullRequestListDialog2.default.showFor('outgoing', branchId, 'all', 'newest');
        });

        (0, _jquery2.default)('.pull-request-list-trigger').tooltip({
            gravity: 'n',
            live: true
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});