define('bitbucket/internal/feature/file-content/diff-view-options', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/util/client-storage', 'bitbucket/internal/util/events'], function (module, exports, _jquery, _lodash, _clientStorage, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _lodash2 = babelHelpers.interopRequireDefault(_lodash);

    var _clientStorage2 = babelHelpers.interopRequireDefault(_clientStorage);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    // Make sure the storageKey only gets initialized when required
    var storageKey = _lodash2.default.once(function () {
        return _clientStorage2.default.buildKey(['diff-view', 'options'], 'user');
    });

    function DiffViewOptions() {}

    _events2.default.addLocalEventMixin(DiffViewOptions.prototype);

    /**
     * Lazily initialize our options here and cache them for future access.
     *
     * @returns {Object}
     */
    DiffViewOptions.prototype.getOptions = _lodash2.default.memoize(function () {
        return _lodash2.default.assign({}, this.defaults, _clientStorage2.default.getItem(storageKey()));
    });

    DiffViewOptions.prototype.defaults = {
        ignoreWhitespace: false,
        showWhitespaceCharacters: false,
        hideComments: false,
        hideEdiff: false,
        diffType: 'unified'
    };

    /**
     * Trigger the currently viewed file to update.
     *
     * Usually after an option has been changed.
     *
     * @param {string} key
     * @param {string} value
     */
    DiffViewOptions.prototype.triggerUpdate = function (key, value) {
        var entry = {
            key: key,
            value: value
        };
        this.trigger('change', entry);
        _events2.default.trigger('bitbucket.internal.feature.fileContent.optionsChanged', null, entry);
    };

    /**
     * Set a diff option
     *
     * We use a setter so that we can keep an internal reference to the
     * key/value pair while also updating clientStorage
     *
     * @param {string} key
     * @param {*} value
     * @param {boolean} [update] trigger an update event?
     */
    DiffViewOptions.prototype.set = function (key, value, update) {
        this.getOptions()[key] = value;
        //Also update storage
        _clientStorage2.default.setItem(storageKey(), this.getOptions());

        if (update !== false) {
            this.triggerUpdate(key, value);
        }
    };

    /**
     * Get a diff option
     *
     * @param {string} key
     * @returns {*}
     */
    DiffViewOptions.prototype.get = function (key) {
        return this.getOptions()[key];
    };

    DiffViewOptions.prototype.proxy = function (overrides) {
        var target = this;
        var proxy = new DiffViewOptions();

        proxy.getOptions = function () {
            return _jquery2.default.extend({}, target.getOptions(), overrides);
        };
        proxy.set = function (key, value, update) {
            if (overrides[key] === undefined) {
                target.set(key, value, update);
            }
        };
        proxy.destroy = _events2.default.chainWith(target).on('change', function (entry) {
            if (overrides[entry.key] === undefined) {
                proxy.trigger('change', entry);
            }
        }).destroy;

        return proxy;
    };

    exports.default = new DiffViewOptions();
    module.exports = exports['default'];
});