define('bitbucket/internal/feature/dashboard/components/repository-list', ['module', 'exports', 'react', 'aui', 'react-dom', '../components/repository-list-item'], function (module, exports, _react, _aui, _reactDom, _repositoryListItem) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _aui2 = babelHelpers.interopRequireDefault(_aui);

    var _reactDom2 = babelHelpers.interopRequireDefault(_reactDom);

    var _repositoryListItem2 = babelHelpers.interopRequireDefault(_repositoryListItem);

    var LoadMore = function LoadMore(onMoreClick) {
        return _react2.default.createElement(
            'button',
            { className: 'load-more-button aui-button aui-button-link', onClick: function onClick() {
                    return onMoreClick();
                } },
            _aui2.default.I18n.getText('bitbucket.web.dashboard.repositories.loadmore')
        );
    };

    var isNotFirstOrLast = function isNotFirstOrLast(el) {
        return el.previousSibling && el.nextSibling;
    };

    var RepositoryList = function (_Component) {
        babelHelpers.inherits(RepositoryList, _Component);

        function RepositoryList() {
            babelHelpers.classCallCheck(this, RepositoryList);
            return babelHelpers.possibleConstructorReturn(this, (RepositoryList.__proto__ || Object.getPrototypeOf(RepositoryList)).apply(this, arguments));
        }

        babelHelpers.createClass(RepositoryList, [{
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                if (this.focusedListEl) {
                    if (isNotFirstOrLast(this.focusedListEl)) {
                        // Try to make the focused element be the second element in the list if possible
                        this.scrollIntoView(this.focusedListEl.previousSibling);
                    } else {
                        this.scrollIntoView(this.focusedListEl);
                    }
                }
            }
        }, {
            key: 'scrollIntoView',
            value: function scrollIntoView(element) {
                if (this.repoList) {
                    this.repoList.scrollTop = element.offsetTop;
                }
            }
        }, {
            key: 'renderListWrapper',
            value: function renderListWrapper(repositories, focusedIndex, onItemClick) {
                var _this2 = this;

                return _react2.default.createElement(
                    'ul',
                    { id: 'dashboard-repo-list' },
                    repositories.map(function (repo, index) {
                        return _react2.default.createElement(_repositoryListItem2.default, {
                            focused: focusedIndex === index,
                            key: repo.id,
                            repository: repo,
                            onItemClick: onItemClick,
                            ref: function ref(el) {
                                focusedIndex === index ? _this2.focusedListEl = _reactDom2.default.findDOMNode(el) : null;
                            }
                        });
                    })
                );
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var _props = this.props,
                    onMoreClick = _props.onMoreClick,
                    repositories = _props.repositories,
                    showMore = _props.showMore,
                    focusedIndex = _props.focusedIndex,
                    onItemClick = _props.onItemClick,
                    EmptyState = _props.EmptyState;

                return _react2.default.createElement(
                    'div',
                    {
                        className: 'dashboard-repository-list-container',
                        ref: function ref(el) {
                            _this3.repoList = el;
                        }
                    },
                    repositories && repositories.length > 0 ? this.renderListWrapper(repositories, focusedIndex, onItemClick) : EmptyState,
                    showMore ? LoadMore(onMoreClick) : null
                );
            }
        }]);
        return RepositoryList;
    }(_react.Component);

    exports.default = RepositoryList;
    module.exports = exports['default'];
});