define('bitbucket/internal/feature/dashboard/components/repository-list-item', ['module', 'exports', 'react', 'classnames', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar'], function (module, exports, _react, _classnames, _navbuilder, _avatar) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var RepositoryListItem = function (_Component) {
        babelHelpers.inherits(RepositoryListItem, _Component);

        function RepositoryListItem() {
            babelHelpers.classCallCheck(this, RepositoryListItem);
            return babelHelpers.possibleConstructorReturn(this, (RepositoryListItem.__proto__ || Object.getPrototypeOf(RepositoryListItem)).apply(this, arguments));
        }

        babelHelpers.createClass(RepositoryListItem, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    repository = _props.repository,
                    focused = _props.focused,
                    onItemClick = _props.onItemClick;

                return _react2.default.createElement(
                    'li',
                    { className: (0, _classnames2.default)({ focused: focused }) },
                    _react2.default.createElement(_avatar.ProjectAvatar, { project: repository.project, size: 'medium' }),
                    _react2.default.createElement(
                        'div',
                        null,
                        _react2.default.createElement(
                            'a',
                            {
                                href: _navbuilder2.default.project(repository.project).repo(repository).build(),
                                className: 'repository',
                                'data-entity': 'repository',
                                'data-repository-id': repository.id,
                                'data-project-id': repository.project.id,
                                title: repository.name,
                                onClick: function onClick(e) {
                                    return onItemClick(e);
                                }
                            },
                            _react2.default.createElement(
                                'strong',
                                null,
                                repository.name
                            )
                        ),
                        _react2.default.createElement(
                            'a',
                            {
                                href: _navbuilder2.default.project(repository.project).build(),
                                className: 'project',
                                'data-entity': 'project',
                                'data-repository-id': repository.id,
                                'data-project-id': repository.project.id,
                                title: repository.project.name,
                                onClick: function onClick(e) {
                                    return onItemClick(e);
                                }
                            },
                            repository.project.name
                        )
                    )
                );
            }
        }]);
        return RepositoryListItem;
    }(_react.Component);

    exports.default = RepositoryListItem;
    module.exports = exports['default'];
});