define('bitbucket/internal/feature/alerts/alerts', ['exports', 'aui', 'jquery', 'lodash', 'bitbucket/util/events', 'bitbucket/internal/feature/alerts/reducers', 'bitbucket/internal/util/redux', './action-creators', './alerts-trigger'], function (exports, _aui, _jquery, _lodash, _events, _reducers, _redux, _actionCreators, _alertsTrigger) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;
    exports.add = add;

    var _aui2 = babelHelpers.interopRequireDefault(_aui);

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _reducers2 = babelHelpers.interopRequireDefault(_reducers);

    var _alertsTrigger2 = babelHelpers.interopRequireDefault(_alertsTrigger);

    var store = (0, _redux.customCreateStore)({
        ui: _reducers2.default
    });

    var loadDialogResources = (0, _lodash.once)(function ($content) {
        var $spinner = (0, _jquery2.default)('<div class="loading-resource-spinner"></div>');
        $content.empty().append($spinner);
        $spinner.show().spin('medium');

        return WRM.require('wrc!bitbucket.alerts').then(function () {
            $content.empty();
        });
    });

    var onShow = function onShow(requireDialog) {
        return function ($content, $trigger, showPopup) {
            loadDialogResources($content).done(function () {
                if (!$content.html()) {
                    requireDialog()($content[0], store);
                }
            });
            store.dispatch((0, _actionCreators.openDialog)());
            _events2.default.trigger('bitbucket.internal.ui.alerts.dialog.opened');
            showPopup();
        };
    };

    function onReady($trigger, requireDialogFn) {
        new _alertsTrigger2.default($trigger, store);
        _aui2.default.InlineDialog($trigger, 'alerts-content', onShow(requireDialogFn), {
            width: 400,
            closeOnTriggerClick: true,
            hideCallback: function hideCallback() {
                return store.dispatch((0, _actionCreators.closeDialog)());
            }
        });
    }

    /**
     * Adds an alert
     * @param alert the alert to add
     * @returns {String} the added alert's key
     */
    function add(alert) {
        return store.dispatch((0, _actionCreators.add)(alert)).payload.alertKey;
    }
});