define('bitbucket/internal/bbui/aui-react/icon', ['module', 'exports', 'classnames', 'prop-types', 'react'], function (module, exports, _classnames, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var _propTypes2 = babelHelpers.interopRequireDefault(_propTypes);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var propTypes = {
        icon: _propTypes2.default.string.isRequired,
        size: _propTypes2.default.oneOf(['small', 'large']),
        title: _propTypes2.default.string,
        children: _propTypes2.default.node
    };

    var defaultProps = {
        size: 'small'
    };

    var Icon = function Icon(props) {
        var icon = props.icon;
        if (!/^aui-iconfont-/.test(icon)) {
            icon = 'aui-iconfont-' + icon;
        }

        return _react2.default.createElement(
            'span',
            {
                className: (0, _classnames2.default)('aui-icon', 'aui-icon-' + props.size, icon),
                title: props.title
            },
            props.children
        );
    };
    Icon.propTypes = propTypes;
    Icon.defaultProps = defaultProps;

    exports.default = Icon;
    module.exports = exports['default'];
});