define('bitbucket/internal/bbui/aui-react/form', ['exports', 'classnames', 'prop-types', 'react'], function (exports, _classnames, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Checkbox = exports.TextField = exports.Error = undefined;

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var _propTypes2 = babelHelpers.interopRequireDefault(_propTypes);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var Error = function Error(_ref) {
        var error = _ref.error;

        if (!error) {
            return null;
        }
        return _react2.default.createElement(
            'ul',
            { className: 'error' },
            error.map(function (err) {
                return _react2.default.createElement(
                    'li',
                    { key: err },
                    err
                );
            })
        );
    };

    Error.propTypes = {
        error: _propTypes2.default.array
    };

    var TextField = function TextField(_ref2) {
        var _ref2$required = _ref2.required,
            required = _ref2$required === undefined ? false : _ref2$required,
            title = _ref2.title,
            name = _ref2.name,
            description = _ref2.description,
            descriptionHtml = _ref2.descriptionHtml,
            onChange = _ref2.onChange,
            value = _ref2.value,
            _ref2$errors = _ref2.errors,
            errors = _ref2$errors === undefined ? [] : _ref2$errors,
            size = _ref2.size,
            maxLength = _ref2.maxLength,
            _ref2$autoFocus = _ref2.autoFocus,
            autoFocus = _ref2$autoFocus === undefined ? false : _ref2$autoFocus;

        var requiredElement = required ? _react2.default.createElement(
            'span',
            { className: 'aui-icon icon-required' },
            '(required)'
        ) : null;
        var descriptionDiv = descriptionHtml ? _react2.default.createElement('div', { className: 'description', dangerouslySetInnerHTML: descriptionHtml }) : _react2.default.createElement(
            'div',
            { className: 'description' },
            description
        );

        return _react2.default.createElement(
            'div',
            { className: 'field-group' },
            _react2.default.createElement(
                'label',
                { htmlFor: 'title' },
                title,
                requiredElement
            ),
            _react2.default.createElement('input', {
                className: (0, _classnames2.default)('text', size && size + '-field'),
                type: 'text',
                id: name,
                name: name,
                value: value,
                onChange: onChange,
                maxLength: maxLength,
                autoFocus: autoFocus
            }),
            descriptionDiv,
            _react2.default.createElement(Error, { error: errors })
        );
    };

    TextField.propTypes = {
        required: _propTypes2.default.bool,
        description: _propTypes2.default.string,
        descriptionHtml: _propTypes2.default.object,
        title: _propTypes2.default.string.isRequired,
        name: _propTypes2.default.string.isRequired,
        onChange: _propTypes2.default.func,
        value: _propTypes2.default.string,
        errors: _propTypes2.default.array,
        size: _propTypes2.default.oneOf(['short', 'medium', 'medium-long', 'long', 'full-width']),
        maxLength: _propTypes2.default.number,
        autoFocus: _propTypes2.default.bool
    };

    var Checkbox = function Checkbox(_ref3) {
        var _ref3$checked = _ref3.checked,
            checked = _ref3$checked === undefined ? false : _ref3$checked,
            description = _ref3.description,
            label = _ref3.label,
            name = _ref3.name,
            id = _ref3.id,
            onChange = _ref3.onChange;
        return _react2.default.createElement(
            'div',
            { className: 'checkbox' },
            _react2.default.createElement('input', {
                'data-grouping': 'trigger',
                className: 'checkbox',
                type: 'checkbox',
                name: name,
                id: id || name,
                onChange: onChange,
                checked: checked
            }),
            _react2.default.createElement(
                'label',
                { htmlFor: id || name },
                label
            ),
            _react2.default.createElement(
                'div',
                { className: 'description' },
                description
            )
        );
    };
    Checkbox.propTypes = {
        checked: _propTypes2.default.bool,
        description: _propTypes2.default.string,
        label: _propTypes2.default.string.isRequired,
        name: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string,
        onChange: _propTypes2.default.func
    };

    exports.Error = Error;
    exports.TextField = TextField;
    exports.Checkbox = Checkbox;
});