define('bitbucket/internal/feature/pull-request/pull-request-diff', [
    'aui',
    'jquery',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/feature/commit/tree-and-diff-view',
    'bitbucket/internal/feature/pull-request/pull-request-history',
    'bitbucket/internal/layout/page-scrolling-manager',
    'bitbucket/internal/model/commit-range',
    'bitbucket/internal/util/events',
    'exports'
], function(
    AJS,
    $,
    nav,
    treeAndDiffView,
    pullRequestHistory,
    pageScrollingManager,
    CommitRange,
    events,
    exports
) {

    function bindAddFileCommentHandler(keys) {
        (this.execute ? this : AJS.whenIType(keys)).execute(function() {
            $('.add-file-comment-trigger:first').click();
        });
    }


    var stopAccepting;
    exports.init = function(pullRequest, maxChanges, relevantContextLines) {

        events.on('bitbucket.internal.keyboard.shortcuts.pullrequest.addCommentHandler', bindAddFileCommentHandler);
        stopAccepting = pageScrollingManager.acceptScrollForwardingRequests();

        treeAndDiffView.init(new CommitRange({ pullRequest : pullRequest }), {
            commentMode : treeAndDiffView.commentMode.CREATE_NEW,
            maxChanges : maxChanges,
            relevantContextLines : relevantContextLines,
            toolbarWebFragmentLocationPrimary : 'bitbucket.pull-request.diff.toolbar.primary',
            toolbarWebFragmentLocationSecondary : 'bitbucket.pull-request.diff.toolbar.secondary',
            diffUrlBuilder : function(fileChange) {
                return nav.rest().currentRepo().pullRequest(pullRequest.id).diff(fileChange);
            }
        });
        pullRequestHistory.init();
    };
    exports.reset = function() {
        events.off('bitbucket.internal.keyboard.shortcuts.pullrequest.addCommentHandler', bindAddFileCommentHandler);
        pullRequestHistory.reset();
        var resetDone = treeAndDiffView.reset();
        stopAccepting();
        return resetDone;
    };
});