define('bitbucket/internal/feature/file-content/file-blame', [
    'jquery',
    'bitbucket/util/events',
    'bitbucket/internal/feature/file-content/file-blame/blame-gutter',
    'bitbucket/internal/feature/file-content/file-blame/blame-source',
    'bitbucket/internal/util/promise',
    'bitbucket/internal/util/shortcuts',
    'bitbucket/internal/widget/button-trigger',
    'exports'
], function (
    $,
    events,
    BlameGutter,
    BlameSource,
    promise,
    shortcuts,
    ButtonTrigger,
    exports
) {
    'use strict';

    exports.init = function() {
        events.on('bitbucket.internal.feature.fileContent.textViewInitializing', onTextView);

        function onTextView(sourceView, context) {
            if (context.contentMode !== 'source') {
                return;
            }
            var blameSource = new BlameSource(context.fileChange);
            var blameGutter = new BlameGutter(sourceView, blameSource);
            var $button = context.$toolbar.find('.file-blame');

            // creating this once ensures we never have duplicated spinners.
            var $spinner = $('<div class="blame-spinner"></div>');
            var blameButton = new ButtonTrigger($button, {
                stopEvent: false,
                triggerHandler: function() {
                    this.setTriggerActive(!this.isTriggerActive());
                    promise.spinner(
                        $spinner.insertBefore($button),
                        blameGutter.setEnabled(this.isTriggerActive()));
                }
            });

            shortcuts.bind('showBlame', blameButton.triggerClicked.bind(blameButton));
            // buttonTrigger doesn't need to destroy
            // sourceView.on('destroy', blameButton.destroy.bind(blameButton));
        }

        return {
            destroy: function destroy() {
                events.off('bitbucket.internal.feature.fileContent.textViewInitializing', onTextView);
            }
        };
    };
});