define(
    'bitbucket/internal/bbui/aui-react/inline-dialog',
    ['exports', 'classnames', 'react', './component'],
    function (exports, _classnames, _react, _component) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _classNames = _interopRequireDefault(_classnames);

        var _React = _interopRequireDefault(_react);

        var _AUIComponent = _interopRequireDefault(_component);

        var triggerPropTypes = {
            children: _react.PropTypes.node,
            className: _react.PropTypes.string,
            dialogId: _react.PropTypes.string.isRequired,
            href: _react.PropTypes.string,
            title: _react.PropTypes.string
        };

        var dialogPropTypes = {
            alignment: _react.PropTypes.string,
            children: _react.PropTypes.node,
            className: _react.PropTypes.string,
            id: _react.PropTypes.string.isRequired
        };

        var dialogDefaultProps = {
            alignment: 'right middle'
        };

        /**
         * Creates a click target to open an InlineDialog. This will be a <button> unless
         * the `href` prop is passed, which will use an <a> element.
         *
         * @param {string} dialogId - The id of the InlineDialog this trigger controls
         * @param {React.children} children - The HTML contents for this trigger
         * @param {string} [className] - Classes to be added to the trigger
         * @param {string} [href] - The link for this trigger
         */

        var InlineDialogTrigger = (function (_Component) {
            _inherits(InlineDialogTrigger, _Component);

            function InlineDialogTrigger(props) {
                _classCallCheck(this, InlineDialogTrigger);

                _get(Object.getPrototypeOf(InlineDialogTrigger.prototype), 'constructor', this).call(this, props);

                this.elementType = 'button';

                this.triggerProps = {
                    'aria-controls': props.dialogId,
                    'aria-haspopup': true,
                    'className': (0, _classNames['default'])('aui-button', props.className),
                    'data-aui-trigger': true,
                    'role': 'button',
                    'title': props.title
                };

                if (props.href) {
                    this.triggerProps = _extends({}, this.triggerProps, {
                        className: props.className,
                        href: props.href,
                        tabIndex: '0'
                    });
                    this.elementType = 'a';
                }
            }

            _createClass(InlineDialogTrigger, [{
                key: 'render',
                value: function render() {
                    return _React['default'].createElement(this.elementType, this.triggerProps, this.props.children);
                }
            }]);

            return InlineDialogTrigger;
        })(_react.Component);

        exports.InlineDialogTrigger = InlineDialogTrigger;

        InlineDialogTrigger.propTypes = triggerPropTypes;

        /**
         * Creates an Inline Dialog.
         *
         * @param {Object} props - Component properties
         * @param {string} props.id - The id of the dialog element. This must match the trigger id
         * @param {React.children} props.children - The HTML contents for this dialog
         * @param {string} [props.className] - Classes to be added to the dialog
         * @param {string} [props.alignment] - The alignment of this dialog.
         * @returns {ReactElement}
         *     See https://docs.atlassian.com/aui/latest/docs/inline-dialog.html#api-reference-alignment
         */
        var InlineDialog = function InlineDialog(props) {
            return _React['default'].createElement(
                _AUIComponent['default'],
                {
                    id: props.id,
                    markup: '<aui-inline-dialog id="' + props.id + '" class="' + props.className + '" alignment="' + props.alignment + '"></aui-inline-dialog>',
                    containerSelector: '#' + props.id + ' .aui-inline-dialog-contents'
                },
                props.children
            );
        };

        InlineDialog.defaultProps = dialogDefaultProps;
        InlineDialog.propTypes = dialogPropTypes;

        exports['default'] = InlineDialog;
    }
);