define(
    'bitbucket/internal/bbui/aui-react/component',
    ['exports', 'module', 'react', 'lodash', 'react-dom'],
    function (exports, module, _react, _lodash, _reactDom) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _2 = _interopRequireDefault(_lodash);

        var _ReactDOM = _interopRequireDefault(_reactDom);

        var propTypes = {
            children: _react.PropTypes.node.isRequired,
            containerSelector: _react.PropTypes.string, // eg. we need to render into the '.aui-inline-dialog-contents' of an aui-inline-dialog
            id: _react.PropTypes.string,
            markup: _react.PropTypes.string.isRequired
        };

        var AUIComponent = (function (_Component) {
            _inherits(AUIComponent, _Component);

            function AUIComponent() {
                _classCallCheck(this, AUIComponent);

                _get(Object.getPrototypeOf(AUIComponent.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(AUIComponent, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var _this = this;

                    var node = _ReactDOM['default'].findDOMNode(this);
                    node.innerHTML = this.props.markup;
                    node.firstChild.id = this.props.id;
                    _2['default'].defer(function () {
                        return _this.updateContent();
                    });
                }
            }, {
                key: 'componentDidUpdate',
                value: function componentDidUpdate() {
                    this.updateContent();
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    _ReactDOM['default'].unmountComponentAtNode(this.getContainer());
                    // if there is an ID also try to remove the component with that ID.
                    // This should take care of any container elements that AUI has moved.
                    if (this.props.id) {
                        var el = document.querySelector('#' + this.props.id);
                        if (el) {
                            el.parentNode.removeChild(el); // update when we drop IE11 support
                        }
                    }
                }
            }, {
                key: 'getContainer',
                value: function getContainer() {
                    if (this._container) {
                        return this._container;
                    }
                    var containerSelector = this.props.containerSelector || '#' + this.props.id;
                    this._container = document.querySelector(containerSelector);
                    return this._container;
                }
            }, {
                key: 'updateContent',
                value: function updateContent() {
                    var content = _React['default'].createElement(
                        'div',
                        null,
                        this.props.children
                    );
                    if (this.getContainer()) {
                        _ReactDOM['default'].render(content, this.getContainer());
                    }
                }
            }, {
                key: 'render',
                value: function render() {
                    return _React['default'].createElement('div', null);
                }
            }]);

            return AUIComponent;
        })(_react.Component);

        AUIComponent.propTypes = propTypes;

        module.exports = AUIComponent;
    }
);