/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.SimpleFeature;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFeatureCondition
implements Condition {
    static final String KEY = "key";
    protected final FeatureManager featureManager;
    private Feature feature;

    public AbstractFeatureCondition(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    protected AbstractFeatureCondition(FeatureManager featureManager, Feature feature) {
        this.featureManager = featureManager;
        this.feature = Objects.requireNonNull(feature, "feature");
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (this.feature == null) {
            String featureKeyAsString = params.get(KEY);
            if (StringUtils.isBlank((CharSequence)featureKeyAsString)) {
                throw new PluginParseException(this.getClass().getSimpleName() + " requires the parameter key");
            }
            try {
                this.feature = StandardFeature.fromKey((String)featureKeyAsString);
            }
            catch (IllegalArgumentException e) {
                this.feature = new SimpleFeature(featureKeyAsString);
            }
        }
    }

    protected Feature getFeature() {
        return this.feature;
    }
}

