/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class ResettableInputStream
extends InputStream {
    private volatile ByteArrayInputStream bis;
    private volatile ByteArrayOutputStream bos;
    private volatile boolean closed;
    private final InputStream delegate;

    public ResettableInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.bis = null;
        this.bos = null;
        this.delegate.close();
    }

    @Override
    public int available() throws IOException {
        return (this.bis != null ? this.bis.available() : 0) + this.delegate.available();
    }

    public void clearMark() {
        this.bos = null;
    }

    public void mark() {
        this.mark(0);
    }

    @Override
    public synchronized void mark(int ignored) {
        this.bos = new ByteArrayOutputStream(2048);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int result = -1;
        if (this.bis != null && (result = this.bis.read()) == -1) {
            this.bis = null;
        }
        if (result == -1) {
            result = this.delegate.read();
        }
        if (result != -1 && this.bos != null) {
            this.bos.write(result);
        }
        return result;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.bis != null) {
            result = this.bis.read(b, off, len);
        }
        if (result == -1) {
            result = this.delegate.read(b, off, len);
        }
        if (result != -1 && this.bos != null) {
            this.bos.write(b, off, result);
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.bos == null) {
            throw new IOException("Cannot call reset without calling mark");
        }
        if (this.closed) {
            throw new IOException("Cannot call reset on an InputStream after it's been closed");
        }
        this.bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.bos = null;
    }
}

