/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public class ProxyUtils {
    private ProxyUtils() {
        throw new UnsupportedOperationException(this.getClass() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static <T> T createProxy(@Nonnull Class<T> interfaceClass, @Nonnull InvocationHandler invocationHandler, Class<?> ... additionalInterfaces) {
        Preconditions.checkNotNull((Object)invocationHandler, (Object)"invocationHandler");
        return ProxyUtils.createProxy(interfaceClass, invocationHandler, invocationHandler.getClass().getClassLoader(), additionalInterfaces);
    }

    @Nonnull
    public static <T> T createProxy(@Nonnull Class<T> interfaceClass, @Nonnull InvocationHandler invocationHandler, @Nonnull ClassLoader classLoader, Class<?> ... additionalInterfaces) {
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        Preconditions.checkNotNull(interfaceClass, (Object)"interfaceClass");
        Preconditions.checkNotNull((Object)invocationHandler, (Object)"invocationHandler");
        Class[] interfaces = (Class[])ArrayUtils.add((Object[])additionalInterfaces, interfaceClass);
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        return interfaceClass.cast(proxy);
    }
}

