/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util.web;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class PeekableHttpServletRequest
extends HttpServletRequestWrapper {
    private final int bufferSize;
    private String content;
    private BufferedServletInputStream inputStream;

    public PeekableHttpServletRequest(HttpServletRequest request, int bufferSize) {
        super(request);
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BufferedServletInputStream(super.getInputStream(), this.bufferSize);
        }
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() throws IOException {
        if (this.content == null) {
            Object inputStream = this.getInputStream();
            inputStream.mark(this.getBufferSize());
            try {
                if ("gzip".equals(this.getHeader("content-encoding"))) {
                    inputStream = new GZIPInputStream((InputStream)inputStream);
                }
                this.content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                this.getInputStream().reset();
            }
        }
        return this.content;
    }

    private static class BufferedServletInputStream
    extends ServletInputStream {
        private final BufferedInputStream inputStream;
        private final int bufferSize;
        private int curPos = -1;
        private int markPos = -1;
        private int maxPos = -1;

        private BufferedServletInputStream(ServletInputStream inputStream, int bufferSize) {
            this.inputStream = new BufferedInputStream((InputStream)inputStream, bufferSize);
            this.bufferSize = bufferSize;
        }

        public int read() throws IOException {
            this.ensureBufferNotAtLimit();
            int result = this.inputStream.read();
            if (result != -1) {
                ++this.curPos;
            }
            return result;
        }

        public int read(@Nonnull byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        public int read(@Nonnull byte[] bytes, int i, int i1) throws IOException {
            int result;
            this.ensureBufferNotAtLimit();
            if (this.maxPos != -1) {
                int bytesAvailable = this.maxPos - this.curPos;
                i1 = Math.min(i1, bytesAvailable);
            }
            if ((result = this.inputStream.read(bytes, i, i1)) > 0) {
                this.curPos += result;
            }
            return result;
        }

        public long skip(long l) throws IOException {
            int limit = this.maxPos != -1 ? this.maxPos : this.bufferSize - 1;
            long maxSkippable = Math.max(0, limit - this.curPos);
            if (l > maxSkippable) {
                return maxSkippable;
            }
            return super.skip(l);
        }

        public int available() throws IOException {
            return this.inputStream.available();
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public void mark(int i) {
            this.inputStream.mark(i);
            this.markPos = this.curPos;
            this.maxPos = this.curPos + i;
        }

        public void reset() throws IOException {
            this.inputStream.reset();
            this.curPos = this.markPos;
            this.maxPos = -1;
        }

        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        private void ensureBufferNotAtLimit() throws IOException {
            if (this.maxPos >= 0 && this.curPos >= this.maxPos) {
                throw new IOException("Buffer is already at the limit, reading more would mean that we can't reset the inputstream");
            }
        }
    }
}

