/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.security;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Defaults;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.junit.Assert;
import org.junit.runners.model.MultipleFailureException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ReflectionUtils;

public class AuthorizedAnnotationHelper {
    private final Class<?> serviceClass;

    public AuthorizedAnnotationHelper(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void testAuthorizedMethods() throws Throwable {
        MultipleFailureException.assertEmpty(this.findBrokenAuthorizedMethods());
    }

    public List<Throwable> findBrokenAuthorizedMethods() throws Exception {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new StashUserAuthenticationToken.Builder().build());
        try {
            List<Throwable> list = AuthorizedAnnotationHelper.validateAnnotations(this.serviceClass);
            return list;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }

    private static Object[] mockArguments(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            args[i] = parameterTypes[i].isPrimitive() ? Defaults.defaultValue(parameterTypes[i]) : (parameterTypes[i] == String.class ? "" : (Modifier.isFinal(parameterTypes[i].getModifiers()) ? null : (!parameterTypes[i].isEnum() && parameterTypes[i].isSealed() ? null : Mockito.mock(parameterTypes[i], (Answer)Mockito.RETURNS_DEEP_STUBS))));
        }
        return args;
    }

    private static Object secureBean(final Class<?> serviceClass, Object bean) {
        ClassPathXmlApplicationContext securityContext = new ClassPathXmlApplicationContext("classpath:/spring/security-test-context.xml");
        ((DefaultMethodSecurityExpressionHandler)securityContext.getBean(DefaultMethodSecurityExpressionHandler.class)).setParameterNameDiscoverer((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer(){

            public String[] getParameterNames(Method method) {
                method = ReflectionUtils.findMethod((Class)serviceClass, (String)method.getName(), (Class[])method.getParameterTypes());
                return super.getParameterNames(method);
            }
        });
        return securityContext.getAutowireCapableBeanFactory().initializeBean(bean, serviceClass.getName());
    }

    private static List<Throwable> validateAnnotations(Class<?> serviceClass) throws Exception {
        PreAuthorize onClass = (PreAuthorize)AnnotationUtils.findAnnotation(serviceClass, PreAuthorize.class);
        Object spy = Mockito.mock(serviceClass);
        Object secureSpy = AuthorizedAnnotationHelper.secureBean(serviceClass, spy);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        ClassUtils.getAllInterfaces(serviceClass).stream().flatMap(serviceInterface -> Arrays.stream(serviceInterface.getDeclaredMethods())).filter(serviceMethod -> Modifier.isPublic(serviceMethod.getModifiers())).forEach(serviceMethod -> {
            Method method = ReflectionUtils.findMethod((Class)serviceClass, (String)serviceMethod.getName(), (Class[])serviceMethod.getParameterTypes());
            try {
                if (AnnotationUtils.findAnnotation((Method)method, PostAuthorize.class) != null) {
                    AuthorizedAnnotationHelper.validatePostAuthorize(spy, secureSpy, serviceMethod, AuthorizedAnnotationHelper.mockArguments(method));
                } else {
                    PreAuthorize onMethod = (PreAuthorize)AnnotationUtils.findAnnotation((Method)method, PreAuthorize.class);
                    if (onClass != null || onMethod != null) {
                        AuthorizedAnnotationHelper.validatePreAuthorize(secureSpy, serviceMethod, AuthorizedAnnotationHelper.mockArguments(method), ((PreAuthorize)MoreObjects.firstNonNull((Object)onMethod, (Object)onClass)).value().equals("permitAll()"));
                    }
                }
            }
            catch (AccessDeniedException onMethod) {
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        });
        return exceptions;
    }

    private static void validatePreAuthorize(Object secureSpy, Method serviceMethod, Object[] args, boolean permitAll) {
        ReflectionUtils.invokeMethod((Method)serviceMethod, (Object)secureSpy, (Object[])args);
        Assert.assertTrue((String)("PreAuthorize has failed: " + serviceMethod), (boolean)permitAll);
    }

    private static void validatePostAuthorize(Object spy, Object secureSpy, Method serviceMethod, Object[] args) throws Exception {
        serviceMethod.invoke(Mockito.doAnswer(invocation -> Mockito.mock(invocation.getMethod().getReturnType(), (Answer)Mockito.RETURNS_DEEP_STUBS)).when(spy), args);
        ReflectionUtils.invokeMethod((Method)serviceMethod, (Object)secureSpy, (Object[])args);
        Assert.fail((String)("PostAuthorize has failed: " + serviceMethod));
    }
}

