/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search;

import com.atlassian.bitbucket.search.SearchSingleNode;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.elasticsearch.client.Client;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.apache.httpclient.ApacheRequestExecutor;
import com.atlassian.elasticsearch.client.apache.httpclient.HttpClientConfiguration;
import com.atlassian.elasticsearch.client.cluster.ClusterHealthRequestBuilder;
import com.atlassian.elasticsearch.client.cluster.ClusterHealthResponse;
import com.atlassian.elasticsearch.client.content.Content;
import com.atlassian.elasticsearch.client.content.ContentVisitors;
import com.atlassian.elasticsearch.client.content.JsonParser;
import com.atlassian.elasticsearch.client.content.JsonRenderer;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.gson.GsonParser;
import com.atlassian.elasticsearch.client.gson.GsonRenderer;
import com.atlassian.elasticsearch.client.internal.AbstractContentResponse;
import com.atlassian.elasticsearch.client.request.RawRequest;
import com.atlassian.elasticsearch.client.request.RawResponse;
import com.atlassian.elasticsearch.client.request.RawResponseHeaders;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import com.atlassian.elasticsearch.client.request.RequestExecutor;
import com.atlassian.elasticsearch.client.request.Response;
import com.atlassian.elasticsearch.client.request.Responses;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.http.HttpRequestInterceptor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

class DockerSearchSingleNode
extends SearchSingleNode {
    private final String hostName;
    private final int port;
    private final HttpRequestInterceptor requestInterceptor;
    private Client client;

    DockerSearchSingleNode(String hostName, int port, HttpRequestInterceptor interceptor) {
        this.hostName = hostName;
        this.port = port;
        this.requestInterceptor = interceptor;
    }

    @Override
    @Nonnull
    public List<String> analyze(@Nonnull String text, @Nonnull String analyzer) {
        return this.executeRequest(new AnalyzeRequestBuilder(Objects.requireNonNull(analyzer, "analyzer"), Objects.requireNonNull(text, "text"))).getTokens();
    }

    @Override
    public void checkClusterHealth() {
        ClusterHealthRequestBuilder requestBuilder = ES.clusterHealth().status("yellow").timeout("60s");
        String healthStatus = ((ClusterHealthResponse)this.executeRequest((RequestBuilder)requestBuilder)).getContent().getStringOrThrow("status");
        MatcherAssert.assertThat((Object)healthStatus, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"green"), (Matcher)Matchers.equalTo((Object)"yellow")));
    }

    @Override
    @Nonnull
    public Map<String, List<String>> getAliases() {
        return this.executeRequest(new AliasesRequest()).getAliases();
    }

    @Override
    @Nonnull
    public Client getClient() {
        return this.client;
    }

    @Override
    @Nonnull
    public URI getServerBaseUrl() {
        if (this.hostName.startsWith("https://")) {
            return URI.create(this.hostName);
        }
        return URI.create("http://" + this.hostName + ":" + this.port);
    }

    @Override
    protected void after() {
        this.client.close();
    }

    @Override
    protected void before() throws Throwable {
        this.client = Client.builder().serverUrl(this.getServerBaseUrl().toASCIIString()).jsonRenderer((JsonRenderer)new GsonRenderer()).jsonParser((JsonParser)new GsonParser()).requestExecutor(this.getRequestExecutor()).build();
    }

    private <T extends Response> T executeRequest(RequestBuilder<T> requestBuilder) {
        try {
            return (T)((Response)this.client.execute(requestBuilder).get());
        }
        catch (IllegalStateException | InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to make request to search server", e);
        }
    }

    private RequestExecutor getRequestExecutor() {
        if (this.requestInterceptor == null) {
            return new ApacheRequestExecutor();
        }
        HttpClientConfiguration.Builder configuration = HttpClientConfiguration.builder().connectionRequestTimeout(Duration.ofSeconds(30L)).connectionTimeout(Duration.ofSeconds(30L)).socketTimeout(Duration.ofSeconds(30L));
        configuration.customConfigurer(client -> client.addInterceptorLast(this.requestInterceptor));
        return new ApacheRequestExecutor(configuration.build());
    }

    private static class AnalyzeRequestBuilder
    implements RequestBuilder<AnalyzeResponse> {
        private final String analyzer;
        private final String text;

        private AnalyzeRequestBuilder(String analyzer, String text) {
            this.analyzer = analyzer;
            this.text = text;
        }

        @Nonnull
        public RawRequest build(@Nonnull JsonRenderer jsonRenderer) {
            return RawRequest.get().segment("bitbucket-search").segment("_analyze").content(jsonRenderer.render((Content)ES.objectContent().with("analyzer", this.analyzer).with("text", this.text).build())).build();
        }

        @Nonnull
        public AnalyzeResponse parseResponse(@Nonnull RawResponse response, @Nonnull RawRequest request, @Nonnull JsonParser jsonParser) {
            ObjectContent content = Responses.parseObjectContent((RawResponse)response, (RawRequest)request, (JsonParser)jsonParser);
            return new AnalyzeResponse(response.getStatusCode(), response.getHeaders(), content);
        }
    }

    private static class AnalyzeResponse
    extends AbstractContentResponse {
        private AnalyzeResponse(int statusCode, @Nonnull RawResponseHeaders headers, @Nonnull ObjectContent content) {
            super(statusCode, headers, content);
        }

        private List<String> getTokens() {
            return (List)this.getContent().getArray("tokens").stream().map(content -> (ObjectContent)content.accept(ContentVisitors.objectContentSelfVisitor())).filter(Objects::nonNull).map(token -> token.getStringOrThrow("token")).collect(MoreCollectors.toImmutableList());
        }
    }

    private static class AliasesRequest
    implements RequestBuilder<AliasesResponse> {
        private AliasesRequest() {
        }

        @Nonnull
        public RawRequest build(@Nonnull JsonRenderer jsonRenderer) {
            return RawRequest.get().segment("_alias").build();
        }

        @Nonnull
        public AliasesResponse parseResponse(@Nonnull RawResponse response, @Nonnull RawRequest request, @Nonnull JsonParser jsonParser) {
            ObjectContent content = Responses.parseObjectContent((RawResponse)response, (RawRequest)request, (JsonParser)jsonParser);
            return new AliasesResponse(response.getStatusCode(), response.getHeaders(), content);
        }
    }

    private static class AliasesResponse
    extends AbstractContentResponse {
        private AliasesResponse(int statusCode, @Nonnull RawResponseHeaders headers, @Nonnull ObjectContent content) {
            super(statusCode, headers, content);
        }

        private Map<String, List<String>> getAliases() {
            ObjectContent indices = this.getContent();
            return (Map)indices.names().stream().collect(MoreCollectors.toImmutableMap(Function.identity(), index -> (List)indices.getObjectContentOrThrow(index).getObjectContentOrThrow("aliases").names().stream().collect(MoreCollectors.toImmutableList())));
        }
    }

    public static class Builder {
        private String hostName;
        private HttpRequestInterceptor interceptor = null;
        private int port;

        public DockerSearchSingleNode build() {
            return new DockerSearchSingleNode(this.hostName, this.port, this.interceptor);
        }

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setInterceptor(HttpRequestInterceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }
    }
}

