/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.context;

import com.google.common.base.Throwables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractAnnotationTestExecutionListener<T extends Annotation>
extends AbstractTestExecutionListener {
    private final Class<T> annotationClass;

    protected AbstractAnnotationTestExecutionListener(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void prepareTestInstance(TestContext testContext) {
        Class testClass = testContext.getTestClass();
        ReflectionUtils.doWithFields((Class)testClass, field -> {
            try {
                T annotation = this.getAnnotation(field, this.annotationClass);
                if (annotation != null) {
                    this.validateAnnotation(field, annotation);
                    this.applyAnnotation(testContext, field, annotation);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    protected void applyAnnotation(TestContext testContext, Field field, T annotation) throws Exception {
        Object value = this.createValue(field, annotation);
        field.setAccessible(true);
        field.set(testContext.getTestInstance(), value);
    }

    protected abstract Object createValue(Field var1, T var2) throws Exception;

    protected T getAnnotation(Field field, Class<T> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    protected void validateAnnotation(Field field, T annotation) {
    }
}

