/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import javax.annotation.Nonnull;

public class RefTestUtils {
    private RefTestUtils() {
        throw new UnsupportedOperationException("This is a utility class");
    }

    @Nonnull
    public static MinimalRef minimalBranch(@Nonnull String name) {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id("refs/heads/" + name)).displayId(name)).type((RefType)StandardRefType.BRANCH).build();
    }

    @Nonnull
    public static MinimalRef minimalPR(int id) {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id("refs/pull-requests/" + id)).displayId("")).type((RefType)StandardRefType.BRANCH).build();
    }

    @Nonnull
    public static MinimalRef minimalRef(@Nonnull String name, @Nonnull RefType type) {
        return StandardRefType.TAG.equals((Object)type) ? RefTestUtils.minimalTag(name) : RefTestUtils.minimalBranch(name);
    }

    @Nonnull
    public static MinimalRef minimalTag(@Nonnull String name) {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id("refs/tags/" + name)).displayId(name)).type((RefType)StandardRefType.TAG).build();
    }
}

