/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.topic;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;

public class SimpleTopicService
implements TopicService,
TestRule {
    private final List<SimpleMessage<?>> messages;
    private final ClusterNode node = (ClusterNode)Mockito.mock(ClusterNode.class);
    private final ConcurrentMap<String, SimpleTopic<?>> topics;

    public SimpleTopicService() {
        this.messages = new CopyOnWriteArrayList();
        this.topics = new ConcurrentHashMap();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    SimpleTopicService.this.reset();
                }
            }
        };
    }

    @Nonnull
    public <T extends Serializable> List<TopicListener<T>> getListeners(@Nonnull String topicName) {
        SimpleTopic topic = (SimpleTopic)this.topics.get(topicName);
        return topic == null ? Collections.emptyList() : ImmutableList.copyOf(topic.listeners.values());
    }

    @Nonnull
    public <T extends Serializable> Topic<T> getTopic(@Nonnull String topic, @Nonnull TopicSettings<T> settings) {
        return this.topics.computeIfAbsent(Objects.requireNonNull(topic, "topic"), key -> new SimpleTopic((String)key, Objects.requireNonNull(settings, "Settings")));
    }

    @Nonnull
    public List<MessageEvent<?>> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void reset() {
        this.messages.clear();
        this.topics.clear();
    }

    class SimpleTopic<T extends Serializable>
    implements Topic<T> {
        private final Map<String, TopicListener<T>> listeners;
        private final String name;
        private final TopicSettings<T> settings;
        private int counter;

        SimpleTopic(String name, TopicSettings<T> settings) {
            this.name = name;
            this.settings = settings;
            this.listeners = new ConcurrentHashMap<String, TopicListener<T>>();
        }

        @Nonnull
        public TopicSettings<T> getSettings() {
            return this.settings;
        }

        public void publish(@Nonnull T message) {
            SimpleMessage messageEvent = new SimpleMessage(SimpleTopicService.this, this.name, message);
            SimpleTopicService.this.messages.add(messageEvent);
            this.listeners.values().forEach(listener -> {
                try {
                    listener.onMessage((MessageEvent)messageEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        @Nonnull
        public String subscribe(@Nonnull TopicListener<T> listener) {
            String subscriptionId = "subscriber-" + this.counter++;
            this.listeners.put(subscriptionId, Objects.requireNonNull(listener, "listener"));
            return subscriptionId;
        }

        public boolean unsubscribe(@Nonnull String subscriptionId) {
            return this.listeners.remove(subscriptionId) != null;
        }
    }

    static class SimpleMessage<T extends Serializable>
    implements MessageEvent<T> {
        private final Date date;
        private final T message;
        private final String topicName;
        final /* synthetic */ SimpleTopicService this$0;

        SimpleMessage(String topicName, T message) {
            this.this$0 = this$0;
            this.message = message;
            this.topicName = topicName;
            this.date = new Date();
        }

        @Nonnull
        public T getMessage() {
            return this.message;
        }

        @Nonnull
        public Date getPublishTime() {
            return this.date;
        }

        @Nonnull
        public ClusterNode getSource() {
            return this.this$0.node;
        }

        @Nonnull
        public String getTopic() {
            return this.topicName;
        }
    }
}

