/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class PermittedGroupMatchers {
    @Nonnull
    public static Matcher<PermittedGroup> permittedGroup(@Nullable String expectedGroup, @Nullable Permission expectedPermission) {
        return Matchers.allOf(PermittedGroupMatchers.withGroup(expectedGroup), PermittedGroupMatchers.withPermission(expectedPermission));
    }

    @Nonnull
    public static Matcher<PermittedGroup> withGroup(@Nullable String expectedGroup) {
        return PermittedGroupMatchers.withGroupThat((Matcher<String>)Matchers.is((Object)expectedGroup));
    }

    @Nonnull
    public static Matcher<PermittedGroup> withGroupThat(@Nonnull Matcher<String> groupMatcher) {
        return new FeatureMatcher<PermittedGroup, String>(groupMatcher, "group that", "group"){

            protected String featureValueOf(PermittedGroup actual) {
                return actual.getGroup();
            }
        };
    }

    @Nonnull
    public static Matcher<PermittedGroup> withPermission(@Nullable Permission expectedPermission) {
        return PermittedGroupMatchers.withPermissionThat((Matcher<Permission>)Matchers.is((Object)expectedPermission));
    }

    @Nonnull
    public static Matcher<PermittedGroup> withPermissionThat(@Nonnull Matcher<Permission> permissionMatcher) {
        return new FeatureMatcher<PermittedGroup, Permission>(permissionMatcher, "permission that", "permission"){

            protected Permission featureValueOf(PermittedGroup actual) {
                return actual.getPermission();
            }
        };
    }
}

