/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class ResponseMatchers {
    private ResponseMatchers() {
        throw new UnsupportedOperationException(this.getClass().getName() + " should not be instantiated");
    }

    @Nonnull
    public static Matcher<HttpServletResponse> hasHeader(@Nonnull String key, @Nullable String value) {
        return new IsHeaderContaining((Matcher<String>)Matchers.equalTo((Object)key), (Matcher<String>)Matchers.equalTo((Object)value));
    }

    @Nonnull
    public static Matcher<HttpServletResponse> hasHeader(@Nonnull Matcher<String> key, @Nonnull Matcher<String> value) {
        return new IsHeaderContaining(key, value);
    }

    private static class IsHeaderContaining
    extends TypeSafeMatcher<HttpServletResponse> {
        private final Matcher<String> key;
        private final Matcher<String> value;

        private IsHeaderContaining(Matcher<String> key, Matcher<String> value) {
            this.key = key;
            this.value = value;
        }

        protected boolean matchesSafely(HttpServletResponse response) {
            for (String headerName : response.getHeaderNames()) {
                if (!this.key.matches((Object)headerName)) continue;
                String actualValue = response.getHeader(headerName);
                return this.value.matches((Object)actualValue);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("a response with the header [").appendDescriptionOf(this.key).appendText("->").appendDescriptionOf(this.value).appendText("]");
        }
    }
}

