/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.async;

import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.util.Operation;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class WaitConditions {
    public static <T, E extends Exception> WaitCondition match(Operation<T, E> value, Matcher<T> expected) {
        return WaitConditions.match("Timed out waiting for condition", value, expected);
    }

    public static <T, E extends Exception> WaitCondition match(final String message, final Operation<T, E> value, final Matcher<T> expected) {
        return new WaitCondition(){
            T lastValue;

            @Override
            public void describeFailure(Description description) {
                description.appendText(message).appendText("\n expected ");
                expected.describeTo(description);
                description.appendText("\n but ");
                expected.describeMismatch(this.lastValue, description);
            }

            @Override
            public boolean test() throws Exception {
                this.lastValue = value.perform();
                return expected.matches(this.lastValue);
            }
        };
    }

    public static <T> WaitCondition value(Operation<T, Exception> value, T expected) {
        return WaitConditions.match("Timed out waiting for value", value, Matchers.equalTo(expected));
    }

    public static <T> WaitCondition value(String message, Operation<T, Exception> value, T expected) {
        return WaitConditions.match(message, value, Matchers.equalTo(expected));
    }
}

