/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.async;

import com.atlassian.bitbucket.async.WaitCondition;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTestUtils {
    public static final long DEFAULT_RETRY_INTERVAL_MILLIS = 50L;
    private static final long DEFAULT_EXECUTION_TIMEOUT_MILLIS = 10000L;
    private static final Logger log = LoggerFactory.getLogger(AsyncTestUtils.class);
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();

    private AsyncTestUtils() {
    }

    public static void assertThreadInState(Thread.State state, Thread thread, long timeoutMs) {
        AsyncTestUtils.assertThreadInState(null, state, thread, timeoutMs);
    }

    public static void assertThreadInState(String message, Thread.State state, Thread thread, long timeoutMs) {
        long timeoutTimestamp = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() < timeoutTimestamp && thread.getState() != state) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertEquals((String)message, (Object)((Object)state), (Object)((Object)thread.getState()));
    }

    public static void assertThreadNotInState(Thread.State state, Thread thread, long timeoutMs) {
        AsyncTestUtils.assertThreadNotInState(null, state, thread, timeoutMs);
    }

    public static void assertThreadNotInState(String message, Thread.State state, Thread thread, long timeoutMs) {
        long timeoutTimestamp = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() < timeoutTimestamp && thread.getState() == state) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertNotEquals((String)message, (Object)((Object)state), (Object)((Object)thread.getState()));
    }

    public static void assertWaitForChangedBy(int expectedChange, final Callable<Integer> valueProvider, Callable<Void> action, final long maxWaitTime) throws Exception {
        final int initialValue = valueProvider.call();
        final int expectedValue = initialValue + expectedChange;
        action.call();
        AsyncTestUtils.waitFor(new WaitCondition(){
            private int newValue;

            @Override
            public void describeFailure(Description description) throws Exception {
                description.appendText(String.format("Expected %d to have changed to %d but was %d after %dms", initialValue, expectedValue, this.newValue, maxWaitTime));
            }

            @Override
            public boolean test() throws Exception {
                this.newValue = (Integer)valueProvider.call();
                return this.newValue == expectedValue;
            }
        }, maxWaitTime);
    }

    public static void waitFor(WaitCondition waitCondition, long timeoutMs, long retryIntervalMs) {
        AsyncTestUtils.waitFor(waitCondition, timeoutMs, retryIntervalMs, 10000L);
    }

    public static void waitFor(WaitCondition waitCondition, long timeoutMs, long retryIntervalMs, long executionTimeoutMs) {
        long startTime = System.currentTimeMillis();
        boolean conditionPassed = AsyncTestUtils.testCondition(waitCondition, Math.min(executionTimeoutMs, timeoutMs));
        while (!conditionPassed && System.currentTimeMillis() - startTime < timeoutMs) {
            try {
                Thread.sleep(retryIntervalMs);
                conditionPassed = AsyncTestUtils.testCondition(waitCondition, Math.min(executionTimeoutMs, timeoutMs));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (!conditionPassed) {
            StringDescription desc = new StringDescription();
            try {
                waitCondition.describeFailure((Description)desc);
            }
            catch (Exception e) {
                log.error("Error describing failure for wait condition");
                throw new AssertionError((Object)e);
            }
            throw new AssertionError((Object)desc.toString());
        }
    }

    public static void waitFor(WaitCondition waitCondition, long timeoutMs) {
        AsyncTestUtils.waitFor(waitCondition, timeoutMs, 50L);
    }

    private static boolean testCondition(WaitCondition waitCondition, long executionTimeoutMillis) {
        Future<Boolean> result = executorService.submit(waitCondition::test);
        try {
            return result.get(executionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.warn("Exception occured when getting wait condition. Will try again if within timeout period", (Throwable)e);
            result.cancel(true);
            return false;
        }
    }
}

