/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.wiremock;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import org.hamcrest.Description;

public class WiremockTestUtils {
    public static final long DEFAULT_TIMEOUT_MS = 5000L;

    private WiremockTestUtils() {
        throw new UnsupportedOperationException("WiremockTestUtils is a utility class and should not be instantiated");
    }

    public static void waitForRequest(WireMockServer wiremock, RequestPatternBuilder requestPatternBuilder) {
        WiremockTestUtils.waitForRequest(wiremock, requestPatternBuilder, 5000L);
    }

    public static void waitForRequest(final WireMockServer wiremock, final RequestPatternBuilder requestPatternBuilder, long timeout) {
        AsyncTestUtils.waitFor(new WaitCondition(){
            VerificationException lastException;

            @Override
            public void describeFailure(Description description) {
                description.appendText("Timed out waiting for request: \n" + requestPatternBuilder.build());
                if (this.lastException != null) {
                    description.appendText("\n").appendText(this.lastException.getMessage());
                }
            }

            @Override
            public boolean test() {
                try {
                    wiremock.verify(requestPatternBuilder);
                    return true;
                }
                catch (VerificationException e) {
                    this.lastException = e;
                    return false;
                }
            }
        }, timeout);
    }
}

