/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.spring;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParameters;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class SpringParametersRunnerFactory
implements ParametersRunnerFactory {
    public Runner createRunnerForTestWithParameters(final TestWithParameters test) throws InitializationError {
        final BlockJUnit4ClassRunnerWithParameters runnerWithParameters = new BlockJUnit4ClassRunnerWithParameters(test);
        return new SpringJUnit4ClassRunner(test.getTestClass().getJavaClass()){

            protected Object createTest() throws Exception {
                Object testInstance = runnerWithParameters.createTest();
                this.getTestContextManager().prepareTestInstance(testInstance);
                return testInstance;
            }

            protected String testName(FrameworkMethod method) {
                return method.getName() + test.getName();
            }

            public Description getDescription() {
                return runnerWithParameters.getDescription();
            }
        };
    }
}

