/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleFeatureManager
implements FeatureManager {
    private final Map<Feature, Boolean> availableByFeature = new HashMap<Feature, Boolean>();
    private final Map<Feature, Boolean> enabledByFeature = new HashMap<Feature, Boolean>();

    public void clear() {
        this.availableByFeature.clear();
        this.enabledByFeature.clear();
    }

    public boolean isAvailable(@Nonnull Feature feature) {
        return this.availableByFeature.getOrDefault(feature, true);
    }

    public boolean isDisabled(@Nonnull Feature feature) {
        return this.isDisabled(feature, true);
    }

    public boolean isDisabled(@Nonnull Feature feature, boolean defaultValue) {
        return !this.isEnabled(feature, defaultValue);
    }

    public boolean isEnabled(@Nonnull Feature feature) {
        return this.isEnabled(feature, true);
    }

    public boolean isEnabled(@Nonnull Feature feature, boolean defaultValue) {
        return this.enabledByFeature.getOrDefault(feature, defaultValue);
    }

    public void requireEnabled(@Nonnull Feature feature, boolean defaultValue) {
        Objects.requireNonNull(feature, "feature");
        String msgDisabled = String.format("Feature [%s] is disabled", feature.getKey());
        String msgUnavailable = String.format("Feature [%s] is unavailable", feature.getKey());
        if (this.isEnabled(feature, defaultValue)) {
            return;
        }
        throw new FeatureDisabledException(new KeyedMessage(msgDisabled, msgDisabled, msgDisabled));
    }

    public void requireEnabled(@Nonnull Feature feature) {
        this.requireEnabled(feature, false);
    }

    public void setAvailable(@Nonnull Feature feature, boolean available) {
        this.availableByFeature.put(Objects.requireNonNull(feature, "feature"), available);
    }

    public void setEnabled(@Nonnull Feature feature, boolean enabled) {
        this.enabledByFeature.put(Objects.requireNonNull(feature, "feature"), enabled);
    }
}

