/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search;

import com.atlassian.bitbucket.search.DockerSearchSingleNode;
import com.atlassian.elasticsearch.client.Client;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public abstract class SearchSingleNode
extends ExternalResource {
    protected static final String SEARCH_INDEX_NAME = "bitbucket-search";

    @Nonnull
    public abstract List<String> analyze(@Nonnull String var1, @Nonnull String var2);

    public abstract void checkClusterHealth();

    @Nonnull
    public abstract Map<String, List<String>> getAliases();

    @Nonnull
    public abstract Client getClient();

    @Nonnull
    public abstract URI getServerBaseUrl();

    @Nonnull
    public static SearchSingleNode searchNode() {
        String searchHost = System.getProperty("search.host", "localhost");
        String searchPort = System.getProperty("search.port", "7992");
        if (StringUtils.isNotEmpty((CharSequence)searchHost) && StringUtils.isNotEmpty((CharSequence)searchPort)) {
            return new DockerSearchSingleNode(searchHost, Integer.parseInt(searchPort));
        }
        throw new RuntimeException("'search.host' and 'search.port' system properties should be set and an external search server instance should available to run search integration tests");
    }

    protected abstract void after();

    protected abstract void before() throws Throwable;
}

