/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(RepeatRule.class);
    private static final int REPEAT_LIMIT = Integer.getInteger("stash.test.repeat.count", 1);
    private final int maxCount;
    private int count;

    public RepeatRule() {
        this(REPEAT_LIMIT);
    }

    public RepeatRule(int maxCount) {
        this.maxCount = maxCount;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                for (int i = 0; i < RepeatRule.this.maxCount; ++i) {
                    try {
                        RepeatRule.this.count++;
                        base.evaluate();
                        continue;
                    }
                    catch (Throwable throwable) {
                        log.error("{}: Test run {} failed", new Object[]{description, i + 1, throwable});
                        throw throwable;
                    }
                }
                log.info("{}: Test has run {} time{}.", new Object[]{description, RepeatRule.this.count, RepeatRule.this.count == 1 ? "" : "s"});
            }
        };
    }

    public int getTestRunCount() {
        return this.count;
    }

    public int getTestRunMaxCount() {
        return this.maxCount;
    }
}

