/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.junit.rules.TestWatcher;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

public class LogAssert
extends TestWatcher {
    private static final Logger ROOT = (Logger)LoggerFactory.getLogger((String)"ROOT");
    private final org.slf4j.event.Level minimumLevel;
    private final Appender<ILoggingEvent> mockAppender;
    private Level previousLevel;

    public LogAssert(org.slf4j.event.Level minimumLevel) {
        Appender mockAppender;
        this.minimumLevel = minimumLevel;
        this.mockAppender = mockAppender = (Appender)Mockito.mock(Appender.class);
    }

    public Assert verify() {
        return new Assert();
    }

    protected void finished(org.junit.runner.Description description) {
        ROOT.setLevel(this.previousLevel);
        ROOT.detachAppender(this.mockAppender);
    }

    protected void starting(org.junit.runner.Description description) {
        this.previousLevel = ROOT.getLevel();
        switch (this.minimumLevel) {
            case DEBUG: {
                ROOT.setLevel(Level.DEBUG);
                break;
            }
            case ERROR: {
                ROOT.setLevel(Level.ERROR);
                break;
            }
            case INFO: {
                ROOT.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                ROOT.setLevel(Level.WARN);
            }
        }
        ROOT.addAppender(this.mockAppender);
    }

    public class Assert {
        public Assert debug(Matcher<String> message) {
            return this.doVerify(Level.DEBUG, message);
        }

        public Assert debug(VerificationMode mode, Matcher<String> message) {
            return this.doVerify(mode, Level.DEBUG, message);
        }

        public Assert debug(Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(Level.DEBUG, message, exception);
        }

        public Assert debug(VerificationMode mode, Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(mode, Level.DEBUG, message, exception);
        }

        public Assert error(Matcher<String> message) {
            return this.doVerify(Level.ERROR, message);
        }

        public Assert error(VerificationMode mode, Matcher<String> message) {
            return this.doVerify(mode, Level.ERROR, message);
        }

        public Assert error(Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(Level.ERROR, message, exception);
        }

        public Assert error(VerificationMode mode, Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(mode, Level.ERROR, message, exception);
        }

        public Assert info(Matcher<String> message) {
            return this.doVerify(Level.INFO, message);
        }

        public Assert info(VerificationMode mode, Matcher<String> message) {
            return this.doVerify(mode, Level.INFO, message);
        }

        public Assert info(Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(Level.INFO, message, exception);
        }

        public Assert info(VerificationMode mode, Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(mode, Level.INFO, message, exception);
        }

        public Assert warn(Matcher<String> message) {
            return this.doVerify(Level.WARN, message);
        }

        public Assert warn(VerificationMode mode, Matcher<String> message) {
            return this.doVerify(mode, Level.WARN, message);
        }

        public Assert warn(Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(Level.WARN, message, exception);
        }

        public Assert warn(VerificationMode mode, Matcher<String> message, Matcher<? extends Throwable> exception) {
            return this.doVerify(mode, Level.WARN, message, exception);
        }

        private Assert doVerify(Level level, Matcher<String> message) {
            ((Appender)Mockito.verify((Object)LogAssert.this.mockAppender)).doAppend(ArgumentMatchers.argThat((ArgumentMatcher)new LoggingEventArgumentMatcher((Matcher<Level>)Matchers.equalTo((Object)level), message)));
            return this;
        }

        private Assert doVerify(VerificationMode mode, Level level, Matcher<String> message) {
            ((Appender)Mockito.verify((Object)LogAssert.this.mockAppender, (VerificationMode)mode)).doAppend(ArgumentMatchers.argThat((ArgumentMatcher)new LoggingEventArgumentMatcher((Matcher<Level>)Matchers.equalTo((Object)level), message)));
            return this;
        }

        private Assert doVerify(Level level, Matcher<String> message, Matcher<? extends Throwable> exception) {
            ((Appender)Mockito.verify((Object)LogAssert.this.mockAppender)).doAppend(ArgumentMatchers.argThat((ArgumentMatcher)new LoggingEventArgumentMatcher((Matcher<Level>)Matchers.equalTo((Object)level), message, exception)));
            return this;
        }

        private Assert doVerify(VerificationMode mode, Level level, Matcher<String> message, Matcher<? extends Throwable> exception) {
            ((Appender)Mockito.verify((Object)LogAssert.this.mockAppender, (VerificationMode)mode)).doAppend(ArgumentMatchers.argThat((ArgumentMatcher)new LoggingEventArgumentMatcher((Matcher<Level>)Matchers.equalTo((Object)level), message, exception)));
            return this;
        }
    }

    private static class LoggingEventArgumentMatcher
    implements ArgumentMatcher<ILoggingEvent> {
        private final Matcher<? extends Throwable> exception;
        private final Matcher<Level> level;
        private final Matcher<String> message;

        LoggingEventArgumentMatcher(@Nonnull Matcher<Level> level, @Nonnull Matcher<String> message) {
            this.level = level;
            this.message = message;
            this.exception = null;
        }

        LoggingEventArgumentMatcher(@Nonnull Matcher<Level> level, @Nonnull Matcher<String> message, @Nonnull Matcher<? extends Throwable> exception) {
            this.level = level;
            this.message = message;
            this.exception = exception;
        }

        public boolean matches(ILoggingEvent argument) {
            boolean levelAndMessageMatch;
            boolean bl = levelAndMessageMatch = this.level.matches((Object)argument.getLevel()) && this.message.matches((Object)argument.getFormattedMessage());
            if (levelAndMessageMatch && this.exception != null) {
                Throwable throwable = null;
                IThrowableProxy throwableProxy = argument.getThrowableProxy();
                if (throwableProxy instanceof ThrowableProxy) {
                    throwable = ((ThrowableProxy)throwableProxy).getThrowable();
                }
                return this.exception.matches((Object)throwable);
            }
            return levelAndMessageMatch;
        }

        public String toString() {
            StringBuilder toString = new StringBuilder();
            StringDescription toStringDescription = new StringDescription((Appendable)toString);
            toString.append("Level ");
            this.level.describeTo((Description)toStringDescription);
            toString.append(" with message ");
            this.message.describeTo((Description)toStringDescription);
            if (this.exception != null) {
                toString.append(" and exception ");
                this.exception.describeTo((Description)toStringDescription);
            }
            return toString.toString();
        }
    }
}

