/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import com.atlassian.bitbucket.util.MoreFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public class ClasspathResourceRule
extends ExternalResource {
    private final Map<String, File> resources = new HashMap<String, File>(4);

    public File get(String resource) throws IOException {
        File r = this.resources.get(resource);
        if (r == null) {
            r = this.copy(resource);
            this.resources.put(resource, r);
        }
        return r;
    }

    protected void after() {
        this.resources.values().forEach(file -> MoreFiles.deleteQuietly((Path)file.toPath()));
        this.resources.clear();
    }

    private File copy(String resource) throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (stream == null) {
            throw new IOException("Could not find the resource: " + resource);
        }
        String prefix = FilenameUtils.getBaseName((String)resource);
        String extension = FilenameUtils.getExtension((String)resource);
        File file = Files.createTempFile(prefix, StringUtils.isNotEmpty((CharSequence)extension) ? '.' + extension : "", new FileAttribute[0]).toFile();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
        return file.getAbsoluteFile();
    }
}

